/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.yui.markup.html.menu2;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.collections.MiniMap;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.velocity.VelocityContributor;
import org.apache.wicket.velocity.VelocityHeaderContributor;
import org.apache.wicket.velocity.VelocityJavascriptContributor;
import org.wicketstuff.yui.markup.html.contributor.YuiHeaderContributor;
import org.wicketstuff.yui.markup.html.menu2.YuiMenu;
import org.wicketstuff.yui.markup.html.menu2.YuiMenuGroupMenu;

public class YuiMenuGroup
extends Panel {
    private static final long serialVersionUID = 1L;
    public static final String MENU_GROUP_ID = "menuGroup";
    private List<YuiMenu> menus = new ArrayList<YuiMenu>();
    private ListView list;

    public YuiMenuGroup(String elementId) {
        this("menu", elementId);
    }

    public YuiMenuGroup(String wicketId, final String elementId) {
        super(wicketId);
        this.add(new IBehavior[]{YuiHeaderContributor.forModule("menu", null, false, "2.5.2")});
        this.setRenderBodyOnly(true);
        WebMarkupContainer mg = new WebMarkupContainer(MENU_GROUP_ID){

            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                if (!Strings.isEmpty((CharSequence)elementId)) {
                    tag.put("id", (CharSequence)elementId);
                }
                tag.put("class", (CharSequence)"yuimenu");
            }
        };
        this.add(new Component[]{mg});
        this.list = new ListView("menuItems", this.menus){

            protected void populateItem(ListItem item) {
                item.setRenderBodyOnly(true);
                YuiMenuGroupMenu menu = (YuiMenuGroupMenu)item.getModelObject();
                if (0 == item.getIndex()) {
                    menu.addFirstOfType();
                }
                menu.setRenderBodyOnly(true);
                item.add(new Component[]{menu});
            }
        }.setReuseItems(true);
        mg.add(new Component[]{this.list});
        this.add(new IBehavior[]{this.getMenuInit(elementId)});
    }

    public YuiMenu addMenu(IModel label) {
        YuiMenuGroupMenu subMenu = new YuiMenuGroupMenu(label, this.menus.size() == 0, false);
        this.menus.add(subMenu);
        this.list.setList(this.menus);
        return subMenu;
    }

    public YuiMenu addMenu(String label) {
        return this.addMenu((IModel)new Model((Serializable)((Object)label)));
    }

    public YuiMenu addMenu() {
        YuiMenuGroupMenu subMenu = new YuiMenuGroupMenu(false, false);
        this.menus.add(subMenu);
        this.list.setList(this.menus);
        return subMenu;
    }

    private IBehavior getMenuInit(String elementId) {
        MiniMap vars = new MiniMap(2);
        vars.put("menuName", "Menu");
        vars.put("elementId", elementId);
        return new VelocityHeaderContributor().add((VelocityContributor)new VelocityJavascriptContributor(YuiMenuGroup.class, "res/menuinit.vm", Model.valueOf((Map)vars), elementId + "Script"));
    }
}

