/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.yui.markup.html.menu2;

import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxFallbackLink;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.AbstractLink;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.wicketstuff.yui.markup.html.menu2.AbstractYuiMenuItem;
import org.wicketstuff.yui.markup.html.menu2.IYuiMenuAction;
import org.wicketstuff.yui.markup.html.menu2.IYuiMenuAjaxAction;

public class YuiMenuItem
extends AbstractYuiMenuItem {
    private static final long serialVersionUID = 1L;
    public static final String MENU_ITEM_ID = "menuItem";
    public static final String LINK_ID = "link";

    public YuiMenuItem(final IYuiMenuAction action) {
        super(MENU_ITEM_ID);
        Object link = null;
        if (action instanceof AbstractLink) {
            link = (AbstractLink)action;
            if (!link.getId().equals(LINK_ID)) {
                throw new RuntimeException("Link's id needs to be 'link' ");
            }
        } else {
            link = action instanceof IYuiMenuAjaxAction ? new AjaxFallbackLink(LINK_ID, action.getName()){
                private static final long serialVersionUID = 1L;

                public void onClick(AjaxRequestTarget target) {
                    if (action instanceof IYuiMenuAjaxAction && target != null) {
                        ((IYuiMenuAjaxAction)action).onClick(target, YuiMenuItem.LINK_ID);
                    } else {
                        action.onClick();
                    }
                }
            } : new Link(LINK_ID, action.getName()){
                private static final long serialVersionUID = 1L;

                public void onClick() {
                    action.onClick();
                }
            };
        }
        this.getItemContainer().add(new Component[]{link});
        link.add(new Component[]{new Label("linkLabel", action.getName()).setRenderBodyOnly(true)});
        this.newSubMenu("emptyMenu").setVisible(false);
    }

    public YuiMenuItem(String label, AbstractLink link) {
        super(MENU_ITEM_ID);
        if (!link.getId().equals(LINK_ID)) {
            throw new RuntimeException("Link's id needs to be 'link' ");
        }
        this.getItemContainer().add(new Component[]{link});
        link.add(new Component[]{new Label("linkLabel", (IModel)new Model((Serializable)((Object)label))).setRenderBodyOnly(true)});
        this.newSubMenu("emptyMenu").setVisible(false);
    }

    public String getMenuClass() {
        return "yuimenuitem";
    }
}

