/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.yui.markup.html.menu2.contextMenu;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.wicketstuff.yui.markup.html.menu2.contextMenu.AbstractMenuItem;
import org.wicketstuff.yui.markup.html.menu2.contextMenu.MenuItem;
import org.wicketstuff.yui.markup.html.menu2.contextMenu.YuiContextMenuBehavior;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Menu
extends AbstractMenuItem {
    private List<AbstractMenuItem> menuItems = new ArrayList<AbstractMenuItem>();
    private Integer x;
    private Integer y;
    private boolean fixedCenter;
    private String width;
    private String height;
    private Integer zIndex;
    private Integer showDelay;
    private Integer hideDelay;
    private Integer subMenuHideDelay;
    private Integer maxHeight;
    private String className;
    private boolean clickToHide = true;
    private boolean disabled;

    public Menu(String id) {
        this(id, id);
    }

    public Menu(String id, String text) {
        super(id, text);
    }

    public Integer getX() {
        return this.x;
    }

    public void setX(Integer x) {
        this.x = x;
    }

    public Integer getY() {
        return this.y;
    }

    public void setY(Integer y) {
        this.y = y;
    }

    public boolean isFixedCenter() {
        return this.fixedCenter;
    }

    public void setFixedCenter(boolean fixedCenter) {
        this.fixedCenter = fixedCenter;
    }

    public String getWidth() {
        return this.width;
    }

    public void setWidth(String width) {
        this.width = width;
    }

    public String getHeight() {
        return this.height;
    }

    public void setHeight(String height) {
        this.height = height;
    }

    public Integer getZIndex() {
        return this.zIndex;
    }

    public void setZIndex(Integer index) {
        this.zIndex = index;
    }

    public Integer getShowDelay() {
        return this.showDelay;
    }

    public void setShowDelay(Integer showDelay) {
        this.showDelay = showDelay;
    }

    public Integer getHideDelay() {
        return this.hideDelay;
    }

    public void setHideDelay(Integer hideDelay) {
        this.hideDelay = hideDelay;
    }

    public Integer getSubMenuHideDelay() {
        return this.subMenuHideDelay;
    }

    public void setSubMenuHideDelay(Integer subMenuHideDelay) {
        this.subMenuHideDelay = subMenuHideDelay;
    }

    public Integer getMaxHeight() {
        return this.maxHeight;
    }

    public void setMaxHeight(Integer maxHeight) {
        this.maxHeight = maxHeight;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public boolean isClickToHide() {
        return this.clickToHide;
    }

    public void setClickToHide(boolean clickToHide) {
        this.clickToHide = clickToHide;
    }

    @Override
    public boolean isDisabled() {
        return this.disabled;
    }

    @Override
    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public Menu newMenu(String menuId) {
        Menu menu = new Menu(menuId);
        this.add(menu);
        return menu;
    }

    public Menu newMenuItem(String menuId) {
        Menu menu = new Menu(menuId);
        this.add(menu);
        return menu;
    }

    protected void add(AbstractMenuItem child) {
        this.menuItems.add(child);
        child.parent = this;
    }

    public Iterator<AbstractMenuItem> menuItems() {
        return this.menuItems.iterator();
    }

    public MenuItem getMenuItem(String action) {
        MenuItem ret = null;
        for (AbstractMenuItem item : this.menuItems) {
            if (item instanceof Menu) {
                Menu menu = (Menu)item;
                ret = menu.getMenuItem(action);
                if (ret == null) continue;
                break;
            }
            if (!(item instanceof MenuItem) || !item.getMenuId().equals(action)) continue;
            ret = (MenuItem)item;
        }
        return ret;
    }

    public List<MenuItem> getAllMenuItems() {
        ArrayList<MenuItem> items = new ArrayList<MenuItem>();
        for (AbstractMenuItem item : this.menuItems) {
            if (item instanceof Menu) {
                Menu menu = (Menu)item;
                items.addAll(menu.getAllMenuItems());
                continue;
            }
            if (!(item instanceof MenuItem)) continue;
            items.add((MenuItem)item);
        }
        return items;
    }

    public HashMap<String, String> getProperties() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("text", this.getText());
        if (this.x != null) {
            props.put("x", this.x.toString());
        }
        if (this.y != null) {
            props.put("y", this.y.toString());
        }
        props.put("fixedcenter", String.valueOf(this.fixedCenter));
        if (this.width != null) {
            props.put("width", this.width);
        }
        if (this.height != null) {
            props.put("height", this.height);
        }
        if (this.zIndex != null) {
            props.put("zIndex", this.zIndex.toString());
        }
        if (this.showDelay != null) {
            props.put("showdelay", this.showDelay.toString());
        }
        if (this.hideDelay != null) {
            props.put("hidedelay", this.hideDelay.toString());
        }
        if (this.subMenuHideDelay != null) {
            props.put("subMenuHideDelay", this.subMenuHideDelay.toString());
        }
        if (this.maxHeight != null) {
            props.put("maxheight", this.maxHeight.toString());
        }
        if (this.className != null) {
            props.put("classname", this.className);
        }
        if (this.clickToHide) {
            props.put("clicktohide", String.valueOf(this.clickToHide));
        }
        if (this.disabled) {
            props.put("disabled", String.valueOf(this.disabled));
        }
        return props;
    }

    @Override
    public String getItemData(YuiContextMenuBehavior behavior) {
        StringBuffer buf = new StringBuffer();
        buf.append("{");
        HashMap<String, String> props = this.getProperties();
        Iterator<String> keys = props.keySet().iterator();
        while (keys.hasNext()) {
            String key = keys.next();
            buf.append(key).append(": ");
            buf.append("\"").append(props.get(key)).append("\"");
            if (keys.hasNext()) {
                buf.append(",\n");
                continue;
            }
            if (this.menuItems.size() <= 0) continue;
            buf.append(",\n");
        }
        if (this.menuItems.size() > 0) {
            buf.append("submenu: {");
            buf.append("id: \"").append(this.getMenuId()).append("\",\n");
            buf.append("itemdata: [");
            Iterator<AbstractMenuItem> miIter = this.menuItems.iterator();
            while (miIter.hasNext()) {
                AbstractMenuItem mi = miIter.next();
                buf.append(mi.getItemData(behavior));
                if (!miIter.hasNext()) continue;
                buf.append(",\n");
            }
            buf.append("] }");
        }
        buf.append("}\n");
        return buf.toString();
    }
}

