/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.yui.markup.html.menu2.contextMenu;

import java.util.HashMap;
import java.util.Iterator;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.wicketstuff.yui.markup.html.menu2.IYuiMenuAction;
import org.wicketstuff.yui.markup.html.menu2.IYuiMenuAjaxAction;
import org.wicketstuff.yui.markup.html.menu2.contextMenu.AbstractMenuItem;
import org.wicketstuff.yui.markup.html.menu2.contextMenu.YuiContextMenuBehavior;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MenuItem
extends AbstractMenuItem {
    private String helpText;
    private String url;
    private String target;
    private boolean emphasis;
    private boolean strongEmphasis;
    private boolean selected;
    private boolean checked;
    private String classname;
    private String onClick;
    private IYuiMenuAction action;

    public MenuItem(String id, IYuiMenuAction action) {
        this(id, id);
        this.action = action;
        if (action.getName() != null && action.getName().getObject() != null) {
            this.setText(((String)action.getName().getObject()).toString());
        }
    }

    public MenuItem(String id) {
        this(id, id);
    }

    public MenuItem(String id, String text) {
        super(id, text);
    }

    public void onClick() {
        if (this.action != null) {
            this.action.onClick();
        }
    }

    public void onClick(AjaxRequestTarget target, String targetId) {
        if (this.action instanceof IYuiMenuAjaxAction) {
            ((IYuiMenuAjaxAction)this.action).onClick(target, targetId);
        }
    }

    public String getHelpText() {
        return this.helpText;
    }

    public void setHelpText(String helpText) {
        this.helpText = helpText;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public boolean isEmphasis() {
        return this.emphasis;
    }

    public void setEmphasis(boolean emphasis) {
        this.emphasis = emphasis;
    }

    public boolean isStrongEmphasis() {
        return this.strongEmphasis;
    }

    public void setStrongEmphasis(boolean strongEmphasis) {
        this.strongEmphasis = strongEmphasis;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public boolean isChecked() {
        return this.checked;
    }

    public void setChecked(boolean checked) {
        this.checked = checked;
    }

    public String getClassname() {
        return this.classname;
    }

    public void setClassname(String classname) {
        this.classname = classname;
    }

    public String getOnClick() {
        return this.onClick;
    }

    public void setOnClick(String onClick) {
        this.onClick = onClick;
    }

    public HashMap<String, String> getProperties() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("text", this.getText());
        if (this.url != null) {
            props.put("url", this.url);
        }
        if (this.target != null) {
            props.put("target", this.target);
        }
        if (this.emphasis) {
            props.put("emphasis", String.valueOf(this.emphasis));
        }
        if (this.strongEmphasis) {
            props.put("strongemphasis", String.valueOf(this.strongEmphasis));
        }
        if (this.isDisabled()) {
            props.put("disabled", String.valueOf(this.isDisabled()));
        }
        if (this.selected) {
            props.put("selected", String.valueOf(this.selected));
        }
        if (this.checked) {
            props.put("checked", String.valueOf(this.checked));
        }
        if (this.classname != null) {
            props.put("classname", this.classname);
        }
        return props;
    }

    @Override
    public String getItemData(YuiContextMenuBehavior behavior) {
        StringBuffer buf = new StringBuffer();
        buf.append("{");
        HashMap<String, String> props = this.getProperties();
        Iterator<String> keys = props.keySet().iterator();
        while (keys.hasNext()) {
            String key = keys.next();
            buf.append(key).append(": ");
            buf.append("\"").append(props.get(key)).append("\"");
            if (!keys.hasNext()) continue;
            buf.append(",\n");
        }
        buf.append("\n,onclick: { fn: ").append(this.getPathToRoot() + " }");
        buf.append(" }");
        return buf.toString();
    }
}

