/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.yui.markup.html.menu2.contextMenu;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.wicketstuff.yui.markup.html.menu2.contextMenu.AbstractMenuItem;
import org.wicketstuff.yui.markup.html.menu2.contextMenu.Menu;
import org.wicketstuff.yui.markup.html.menu2.contextMenu.MenuItem;
import org.wicketstuff.yui.markup.html.menu2.contextMenu.YuiContextMenuBehavior;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class YuiContextMenu
implements Serializable {
    private List<AbstractMenuItem> menuItems = new ArrayList<AbstractMenuItem>();
    private String menuId;

    public YuiContextMenu(String menuId) {
        this.menuId = menuId;
    }

    public String getMenuId() {
        return this.menuId;
    }

    public void add(AbstractMenuItem item) {
        this.menuItems.add(item);
        item.contextMenu = this;
    }

    public Iterator<AbstractMenuItem> items() {
        return this.menuItems.iterator();
    }

    public MenuItem getMenuItem(String action) {
        MenuItem ret = null;
        for (AbstractMenuItem item : this.menuItems) {
            if (item instanceof Menu) {
                Menu menu = (Menu)item;
                ret = menu.getMenuItem(action);
                if (ret == null) continue;
                break;
            }
            if (!(item instanceof MenuItem) || !item.getMenuId().equals(action)) continue;
            ret = (MenuItem)item;
            break;
        }
        return ret;
    }

    public List<MenuItem> getAllMenuItems() {
        ArrayList<MenuItem> items = new ArrayList<MenuItem>();
        for (AbstractMenuItem item : this.menuItems) {
            if (item instanceof Menu) {
                Menu menu = (Menu)item;
                items.addAll(menu.getAllMenuItems());
                continue;
            }
            if (!(item instanceof MenuItem)) continue;
            items.add((MenuItem)item);
        }
        return items;
    }

    public HashMap<String, String> getProperties() {
        HashMap<String, String> props = new HashMap<String, String>();
        return props;
    }

    public String formatMenuItemData(String trigger, YuiContextMenuBehavior behavior) {
        StringBuffer buf = new StringBuffer();
        buf.append("{");
        buf.append("trigger: ").append(trigger).append(",\n");
        buf.append("itemdata:").append(this.getItemData(behavior)).append("\n");
        HashMap<String, String> props = this.getProperties();
        Iterator<String> keys = props.keySet().iterator();
        while (keys.hasNext()) {
            String key = keys.next();
            buf.append(",");
            buf.append(key).append(": ");
            buf.append("\"").append(props.get(key)).append("\"");
            if (!keys.hasNext()) continue;
            buf.append("\n");
        }
        buf.append("}\n");
        return buf.toString();
    }

    public String getItemData(YuiContextMenuBehavior behavior) {
        StringBuffer buf = new StringBuffer();
        buf.append("[ ");
        Iterator<AbstractMenuItem> miIter = this.menuItems.iterator();
        while (miIter.hasNext()) {
            AbstractMenuItem mi = miIter.next();
            buf.append(mi.getItemData(behavior));
            if (!miIter.hasNext()) continue;
            buf.append(",\n");
        }
        buf.append("]\n");
        return buf.toString();
    }

    public static void main(String[] args) {
        YuiContextMenu contextMenu = new YuiContextMenu("testMenu");
        contextMenu.add(new MenuItem("Cut"));
        contextMenu.add(new MenuItem("Copy"));
        contextMenu.add(new MenuItem("Paste"));
        Menu menu = new Menu("colors");
        menu.add(new MenuItem("Red"));
        menu.add(new MenuItem("Green"));
        menu.add(new MenuItem("Blue"));
        contextMenu.add(menu);
        System.out.println(contextMenu.formatMenuItemData("testTrigger", null));
    }
}

