/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.yui.markup.html.selection;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.HeaderContributor;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.basic.MultiLineLabel;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.template.PackagedTextTemplate;
import org.wicketstuff.yui.helper.CSSInlineStyle;
import org.wicketstuff.yui.helper.YuiAttribute;
import org.wicketstuff.yui.helper.YuiImage;
import org.wicketstuff.yui.helper.YuiTextBox;
import org.wicketstuff.yui.markup.html.contributor.YuiHeaderContributor;
import org.wicketstuff.yui.markup.html.selection.SelectionSettings;

public class Selection
extends Panel {
    private static final long serialVersionUID = 1L;
    private int boxCount = -1;
    private String boxes;
    private final List boxList = new Vector();
    private final ListView boxListView;
    private int count = 0;
    private String counts;
    private double duration;
    private String easing;
    private String elementId;
    private String event;
    private String javaScriptId;
    private List list;
    private int maxSelection;
    private String message;
    private SelectionSettings settings;
    private YuiAttribute yuiAttribute;

    public Selection(String id, SelectionSettings settings) {
        super(id);
        this.add(new IBehavior[]{YuiHeaderContributor.forModule("animation")});
        this.add(new IBehavior[]{HeaderContributor.forCss(Selection.class, (String)"css/style.css")});
        this.elementId = id;
        this.yuiAttribute = settings.getYuiAttribute();
        this.easing = settings.getEasing();
        this.duration = settings.getDuration();
        this.event = settings.getEvent();
        this.maxSelection = settings.getMaxSelection();
        this.message = settings.getMessage();
        this.settings = settings;
        this.list = settings.getList();
        for (int i = 0; i < this.list.size(); ++i) {
            if (i == 0) {
                this.boxes = "'" + this.elementId + "" + i + "'";
                this.counts = "0";
            } else {
                this.boxes = this.boxes + ", '" + this.elementId + "" + i + "'";
                this.counts = this.counts + ", 0 ";
            }
            this.boxList.add(0, this.list.get(i));
        }
        Label initialization = new Label("initialization", (IModel)new AbstractReadOnlyModel(){
            private static final long serialVersionUID = 1L;

            public Object getObject() {
                return Selection.this.getJavaScriptComponentInitializationScript();
            }
        });
        initialization.setEscapeModelStrings(false);
        this.add(new Component[]{initialization});
        Label selection = new Label("selection", (IModel)new AbstractReadOnlyModel(){
            private static final long serialVersionUID = 1L;

            public Object getObject() {
                return Selection.this.getSelectionInitializationScript();
            }
        });
        selection.setEscapeModelStrings(false);
        this.add(new Component[]{selection});
        Component[] componentArray = new Component[1];
        this.boxListView = new ListView("boxContainer", this.boxList){
            private static final long serialVersionUID = 1L;

            public void populateItem(ListItem listItem) {
                if (listItem.getModelObject().getClass().getSimpleName().equals("YuiImage")) {
                    YuiImage aImage = (YuiImage)listItem.getModelObject();
                    SelectionBox sBox = new SelectionBox("box", Selection.this.count++);
                    listItem.add(new Component[]{sBox});
                    MultiLineLabel aLabel = new MultiLineLabel("caption", aImage.getDesc());
                    sBox.add(new Component[]{aLabel});
                } else {
                    YuiTextBox aTextBox = (YuiTextBox)listItem.getModelObject();
                    SelectionBox sBox = new SelectionBox("box", Selection.this.count++);
                    listItem.add(new Component[]{sBox});
                    MultiLineLabel aLabel = new MultiLineLabel("caption", aTextBox.getDesc());
                    sBox.add(new Component[]{aLabel});
                }
            }
        };
        componentArray[0] = this.boxListView;
        this.add(componentArray);
    }

    public void updateModel() {
    }

    protected String getJavaScriptComponentInitializationScript() {
        PackagedTextTemplate template = new PackagedTextTemplate(Selection.class, "init.js");
        HashMap<String, Object> variables = new HashMap<String, Object>(9);
        variables.put("javaScriptId", this.javaScriptId);
        variables.put("attributeOn", this.yuiAttribute.getJsScript());
        variables.put("attributeOff", this.yuiAttribute.getReverseJsScript());
        variables.put("easing", this.easing);
        variables.put("duration", new Double(this.duration));
        variables.put("event", "'" + this.event + "'");
        variables.put("maxSelection", new Integer(this.maxSelection));
        variables.put("boxes", this.boxes);
        variables.put("counts", this.counts);
        template.interpolate(variables);
        return template.getString();
    }

    protected String getSelectionInitializationScript() {
        PackagedTextTemplate template = null;
        if (this.maxSelection == 1) {
            template = new PackagedTextTemplate(Selection.class, "single.js");
        } else if (this.maxSelection > 1) {
            template = new PackagedTextTemplate(Selection.class, "multiple.js");
        }
        HashMap<String, Object> variables = new HashMap<String, Object>(10);
        variables.put("javaScriptId", this.javaScriptId);
        variables.put("attributeOn", this.yuiAttribute.getJsScript());
        variables.put("attributeOff", this.yuiAttribute.getReverseJsScript());
        variables.put("easing", this.easing);
        variables.put("maxSelection", new Integer(this.maxSelection));
        variables.put("duration", new Double(this.duration));
        variables.put("event", "'" + this.event + "'");
        variables.put("boxes", this.boxes);
        variables.put("counts", this.counts);
        variables.put("message", this.message);
        template.interpolate(variables);
        return template.getString();
    }

    protected void onBeforeRender() {
        super.onBeforeRender();
        this.javaScriptId = this.getMarkupId();
    }

    private final class SelectionBox
    extends FormComponent
    implements Serializable {
        private static final long serialVersionUID = 1L;

        public SelectionBox(String id, final int imageId) {
            super(id);
            this.add(new IBehavior[]{new AttributeModifier("id", true, (IModel)new AbstractReadOnlyModel(){
                private static final long serialVersionUID = 1L;

                public Object getObject() {
                    Selection.this.boxCount++;
                    return Selection.this.elementId + "" + Selection.this.boxCount;
                }
            })});
            this.add(new IBehavior[]{new AttributeModifier("style", true, (IModel)new AbstractReadOnlyModel(){
                private static final long serialVersionUID = 1L;

                public Object getObject() {
                    List<CSSInlineStyle> aCSSInlineStyleList = Selection.this.settings.getCSSInlineStyleList();
                    CSSInlineStyle aCSSInlineStyle = aCSSInlineStyleList.get(imageId);
                    return aCSSInlineStyle.getStyle();
                }
            })});
        }
    }
}

