/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.yui.markup.html.selection;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.ResourceReference;
import org.wicketstuff.yui.helper.CSSInlineStyle;
import org.wicketstuff.yui.helper.ImageResourceInfo;
import org.wicketstuff.yui.helper.YuiAttribute;
import org.wicketstuff.yui.helper.YuiImage;
import org.wicketstuff.yui.helper.YuiProperty;
import org.wicketstuff.yui.helper.YuiTextBox;
import org.wicketstuff.yui.markup.html.selection.Selection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectionSettings
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String background;
    private double duration;
    private String easing;
    private String event;
    private int height;
    private List<CSSInlineStyle> CSSInlineStyleList = new ArrayList<CSSInlineStyle>();
    private List list;
    private int maxSelection;
    private String message;
    private int thickness;
    private int width;
    private YuiAttribute yuiAttribute;

    public static SelectionSettings getDefault(YuiAttribute yuiAttribute, String easing, double duration, String event, int maxSelection, ArrayList list) {
        SelectionSettings settings = new SelectionSettings();
        settings.setResources(yuiAttribute, easing, duration, event, maxSelection, list);
        return settings;
    }

    public static SelectionSettings getDefault(YuiAttribute yuiAttribute, String easing, double duration, String event, int maxSelection, String message, ArrayList list) {
        SelectionSettings settings = new SelectionSettings();
        settings.setResources(yuiAttribute, easing, duration, event, maxSelection, message, list);
        return settings;
    }

    public static String jsToCss(String js) {
        String css = "";
        for (int i = 0; i < js.length(); ++i) {
            StringBuffer aStringBuffer = new StringBuffer("");
            aStringBuffer.append(js.charAt(i));
            String aString = aStringBuffer.toString();
            css = aString.equals(aString.toUpperCase()) ? css + "-" + aString.toLowerCase() : css + aString;
        }
        return css;
    }

    public static String removeQuote(String js) {
        String css = "";
        for (int i = 0; i < js.length(); ++i) {
            StringBuffer aStringBuffer = new StringBuffer("");
            aStringBuffer.append(js.charAt(i));
            String aString = aStringBuffer.toString();
            if (aString.equals("'")) continue;
            css = css + aString;
        }
        return css;
    }

    public String getBackground() {
        return this.background;
    }

    public double getDuration() {
        return this.duration;
    }

    public String getEasing() {
        return this.easing;
    }

    public String getEvent() {
        return this.event;
    }

    public int getHeight() {
        return this.height;
    }

    public List<CSSInlineStyle> getCSSInlineStyleList() {
        return this.CSSInlineStyleList;
    }

    public List getList() {
        return this.list;
    }

    public int getMaxSelection() {
        return this.maxSelection;
    }

    public String getMessage() {
        return this.message;
    }

    public int getThickness() {
        return this.thickness;
    }

    public int getWidth() {
        return this.width;
    }

    public YuiAttribute getYuiAttribute() {
        return this.yuiAttribute;
    }

    public void setBackground(String background) {
        this.background = background;
    }

    public void setDuration(double duration) {
        this.duration = duration;
    }

    public void setEasing(String easing) {
        this.easing = easing;
    }

    public void setEvent(String event) {
        this.event = event;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setImageResources(YuiAttribute yuiAttribute, List list) {
        this.setYuiAttribute(yuiAttribute);
        this.setThickness(this.thickness);
        this.setList(list);
        for (int i = list.size() - 1; i >= 0; --i) {
            if (list.get(i).getClass().getSimpleName().equals("YuiImage")) {
                YuiImage aImage = (YuiImage)list.get(i);
                ResourceReference aResourceReference = new ResourceReference(Selection.class, aImage.getFileName());
                ImageResourceInfo backgroundInfo = new ImageResourceInfo(aResourceReference);
                int width = backgroundInfo.getWidth();
                int height = backgroundInfo.getHeight();
                CSSInlineStyle aCSSInlineStyle = new CSSInlineStyle();
                aCSSInlineStyle.add("background", "url(" + RequestCycle.get().urlFor(aResourceReference) + ")");
                aCSSInlineStyle.add("width", width + "px");
                aCSSInlineStyle.add("height", height + "px");
                Map propertyMap = yuiAttribute.getPropertyMap();
                Set keySet = propertyMap.keySet();
                for (String aKey : keySet) {
                    YuiProperty aYuiProperty = (YuiProperty)propertyMap.get(aKey);
                    aCSSInlineStyle.add("border", "solid " + SelectionSettings.removeQuote(aYuiProperty.getFrom()));
                }
                this.CSSInlineStyleList.add(aCSSInlineStyle);
                continue;
            }
            YuiTextBox aTextBox = (YuiTextBox)list.get(i);
            CSSInlineStyle aCSSInlineStyle = new CSSInlineStyle();
            aCSSInlineStyle.add("background", aTextBox.getBackground());
            aCSSInlineStyle.add("width", aTextBox.getWidth() + "px");
            aCSSInlineStyle.add("height", aTextBox.getHeight() + "px");
            Map propertyMap = yuiAttribute.getPropertyMap();
            Set keySet = propertyMap.keySet();
            for (String aKey : keySet) {
                YuiProperty aYuiProperty = (YuiProperty)propertyMap.get(aKey);
                aCSSInlineStyle.add("border", "solid " + SelectionSettings.removeQuote(aYuiProperty.getFrom()));
            }
            this.CSSInlineStyleList.add(aCSSInlineStyle);
        }
    }

    public void setCSSInlineStyleList(List<CSSInlineStyle> CSSInlineStyleList) {
        this.CSSInlineStyleList = CSSInlineStyleList;
    }

    public void setList(List list) {
        this.list = list;
    }

    public void setMaxSelection(int maxSelection) {
        this.maxSelection = maxSelection;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setResources(YuiAttribute yuiAttribute, String easing, double duration, String event, int maxSelection, ArrayList list) {
        this.setEasing("YAHOO.util.Easing." + easing);
        this.setDuration(duration);
        this.setEvent(event);
        this.setMaxSelection(maxSelection);
        this.setImageResources(yuiAttribute, list);
    }

    public void setResources(YuiAttribute yuiAttribute, String easing, double duration, String event, int maxSelection, String message, ArrayList list) {
        this.setEasing("YAHOO.util.Easing." + easing);
        this.setDuration(duration);
        this.setEvent(event);
        this.setMaxSelection(maxSelection);
        this.setMessage("'" + message + "'");
        this.setImageResources(yuiAttribute, list);
    }

    public void setThickness(int thickness) {
        this.thickness = thickness;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setYuiAttribute(YuiAttribute yuiAttribute) {
        this.yuiAttribute = yuiAttribute;
    }
}

