/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.yui.markup.html.slider;

import java.io.Serializable;
import org.apache.wicket.ResourceReference;
import org.wicketstuff.yui.helper.CSSInlineStyle;
import org.wicketstuff.yui.helper.ImageResourceInfo;
import org.wicketstuff.yui.markup.html.slider.Slider;

public class SliderSettings
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Integer startValue;
    private CSSInlineStyle background = new CSSInlineStyle();
    private ResourceReference backgroundResource;
    private CSSInlineStyle handle = new CSSInlineStyle();
    private ResourceReference leftCornerResource;
    private ResourceReference leftTickResource;
    private String leftUp;
    private ResourceReference rightCornerResource;
    private String rightDown;
    private ResourceReference rightTickResource;
    private boolean showTicks = false;
    private CSSInlineStyle thumb = new CSSInlineStyle();
    private ResourceReference thumbResource;
    private String tick;
    private String tickSize;

    public static SliderSettings getAqua(int leftUp, int rightDown, int tick) {
        ResourceReference background = new ResourceReference(Slider.class, "style/aqua/aqua_bg.png");
        ResourceReference thumb = new ResourceReference(Slider.class, "style/aqua/aqua_thumb.gif");
        ResourceReference leftCorner = new ResourceReference(Slider.class, "style/aqua/aqua_left.png");
        ResourceReference leftTick = new ResourceReference(Slider.class, "style/aqua/aqua_left_tick.png");
        ResourceReference rightCorner = new ResourceReference(Slider.class, "style/aqua/aqua_right.png");
        ResourceReference rightTick = new ResourceReference(Slider.class, "style/aqua/aqua_right_tick.png");
        SliderSettings defSettings = new SliderSettings();
        defSettings.setResources(leftUp, rightDown, tick, background, thumb, leftCorner, leftTick, rightCorner, rightTick, true);
        return defSettings;
    }

    public static SliderSettings getAqua(int leftUp, int rightDown, int tick, int startValue) {
        SliderSettings settings = SliderSettings.getAqua(leftUp, rightDown, tick);
        settings.setStartValue(startValue);
        return settings;
    }

    public static SliderSettings getDefault(int leftUp, int rightDown, int tick) {
        ResourceReference background = new ResourceReference(Slider.class, "style/bg.png");
        ResourceReference thumb = new ResourceReference(Slider.class, "style/thumb.png");
        ResourceReference leftCorner = new ResourceReference(Slider.class, "style/left.gif");
        ResourceReference leftTick = new ResourceReference(Slider.class, "style/left_tick.gif");
        ResourceReference rightCorner = new ResourceReference(Slider.class, "style/right.gif");
        ResourceReference rightTick = new ResourceReference(Slider.class, "style/right_tick.gif");
        SliderSettings defSettings = new SliderSettings();
        defSettings.setResources(leftUp, rightDown, tick, background, thumb, leftCorner, leftTick, rightCorner, rightTick, false);
        return defSettings;
    }

    public static SliderSettings getDefault(int leftUp, int rightDown, int tick, int startValue) {
        SliderSettings settings = SliderSettings.getDefault(leftUp, rightDown, tick);
        settings.setStartValue(startValue);
        return settings;
    }

    public CSSInlineStyle getBackground() {
        return this.background;
    }

    public ResourceReference getBackgroundResource() {
        return this.backgroundResource;
    }

    public CSSInlineStyle getHandle() {
        return this.handle;
    }

    public ResourceReference getLeftCornerResource() {
        return this.leftCornerResource;
    }

    public ResourceReference getLeftTickResource() {
        return this.leftTickResource;
    }

    public String getLeftUp() {
        return this.leftUp;
    }

    public ResourceReference getRightCornerResource() {
        return this.rightCornerResource;
    }

    public String getRightDown() {
        return this.rightDown;
    }

    public ResourceReference getRightTickResource() {
        return this.rightTickResource;
    }

    public CSSInlineStyle getThumb() {
        return this.thumb;
    }

    public ResourceReference getThumbResource() {
        return this.thumbResource;
    }

    public String getTick() {
        return this.tick;
    }

    public String getTickSize() {
        return this.tickSize;
    }

    public boolean isShowTicks() {
        return this.showTicks;
    }

    public void setBackground(CSSInlineStyle background) {
        this.background = background;
    }

    public void setBackgroundResource(ResourceReference backgroundResource) {
        this.backgroundResource = backgroundResource;
    }

    public void setHandle(CSSInlineStyle handle) {
        this.handle = handle;
    }

    public void setLeftCornerResource(ResourceReference leftCornerResource) {
        this.leftCornerResource = leftCornerResource;
    }

    public void setLeftTickResource(ResourceReference leftTickResource) {
        this.leftTickResource = leftTickResource;
    }

    public void setLeftUp(String leftUp) {
        this.leftUp = leftUp;
    }

    public void setResources(int leftUp, int rightDown, int tick, ResourceReference background, ResourceReference thumb, ResourceReference leftCorner, ResourceReference leftTick, ResourceReference rightCorner, ResourceReference rightTick, boolean showTicks) {
        this.setShowTicks(showTicks);
        this.setBackgroundResource(background);
        this.setLeftCornerResource(leftCorner);
        this.setRightCornerResource(rightCorner);
        this.setLeftTickResource(leftTick);
        this.setRightTickResource(rightTick);
        this.setThumbResource(thumb);
        ImageResourceInfo bgInfo = new ImageResourceInfo(background);
        ImageResourceInfo thumbInfo = new ImageResourceInfo(thumb);
        int height = bgInfo.getHeight();
        int thumbWidth = thumbInfo.getWidth();
        int left = leftUp - thumbWidth;
        int bgLength = leftUp + rightDown;
        String width = Integer.toString(bgLength - thumbWidth);
        this.setLeftUp(Integer.toString(leftUp));
        this.setRightDown(Integer.toString(rightDown));
        this.setTick(Integer.toString(tick));
        this.getBackground().add("height", height + "px");
        this.getBackground().add("width", width + "px");
        this.getHandle().add("width", thumbWidth + "px");
        this.getHandle().add("height", height + "px");
        this.getHandle().add("top", "0px");
        this.getHandle().add("left", left + "px");
        this.getThumb().add("background-position", "center");
        this.getThumb().add("height", "100%");
        this.getThumb().add("width", thumbWidth + "px");
    }

    public void setRightCornerResource(ResourceReference rightCornerResource) {
        this.rightCornerResource = rightCornerResource;
    }

    public void setRightDown(String rightDown) {
        this.rightDown = rightDown;
    }

    public void setRightTickResource(ResourceReference rightTickResource) {
        this.rightTickResource = rightTickResource;
    }

    public void setShowTicks(boolean showTicks) {
        this.showTicks = showTicks;
    }

    public void setThumb(CSSInlineStyle thumb) {
        this.thumb = thumb;
    }

    public void setThumbResource(ResourceReference thumbResource) {
        this.thumbResource = thumbResource;
    }

    public void setTick(String tick) {
        this.tick = tick;
    }

    public void setTickSize(String tickSize) {
        this.tickSize = tickSize;
    }

    public Integer getStartValue() {
        return this.startValue;
    }

    public void setStartValue(Integer startValue) {
        this.startValue = startValue;
    }
}

