/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.yui.markup.html.slider;

import org.apache.wicket.RequestCycle;
import org.wicketstuff.yui.helper.CSSInlineStyle;
import org.wicketstuff.yui.helper.ImageResourceInfo;
import org.wicketstuff.yui.markup.html.slider.YuiSlider;
import org.wicketstuff.yui.markup.html.slider.YuiSliderSettings;

public class YuiHorizSlider
extends YuiSlider {
    private static final long serialVersionUID = 1L;

    public YuiHorizSlider(String id, YuiSliderSettings settings) {
        super(id, settings);
    }

    protected String getSliderTypJS() {
        return "YAHOO.widget.Slider.getHorizSlider";
    }

    protected String getBackgroundStyle() {
        YuiSliderSettings settings = this.getSliderSettings();
        ImageResourceInfo bgInfo = new ImageResourceInfo(settings.getBackgroundResource());
        ImageResourceInfo thumbInfo = new ImageResourceInfo(settings.getThumbResource());
        int height = bgInfo.getHeight();
        int thumbWidth = thumbInfo.getWidth();
        int bgLength = settings.getLength();
        String width = Integer.toString(bgLength - thumbWidth);
        CSSInlineStyle background = new CSSInlineStyle();
        background.add("height", height + "px");
        background.add("width", width + "px");
        background.add("background", "url(" + RequestCycle.get().urlFor(settings.getBackgroundResource()) + ") repeat-x");
        return background.getStyle();
    }

    protected String getThumbStyle() {
        YuiSliderSettings settings = this.getSliderSettings();
        ImageResourceInfo thumbInfo = new ImageResourceInfo(settings.getThumbResource());
        CSSInlineStyle thumb = new CSSInlineStyle();
        thumb.add("width", thumbInfo.getWidth() + "px");
        thumb.add("left", 0 - thumbInfo.getWidth() + "px");
        return thumb.getStyle();
    }

    protected String getLeftUpStyle() {
        YuiSliderSettings settings = this.getSliderSettings();
        ImageResourceInfo res = new ImageResourceInfo(settings.getLeftUpResource());
        CSSInlineStyle background = new CSSInlineStyle();
        background.add("background", "url(" + RequestCycle.get().urlFor(settings.getLeftUpResource()) + ") no-repeat");
        background.add("width", res.getWidth() + "px");
        background.add("height", res.getHeight() + "px");
        return background.getStyle();
    }

    protected String getRightDownStyle() {
        YuiSliderSettings settings = this.getSliderSettings();
        ImageResourceInfo res = new ImageResourceInfo(settings.getRightDownResource());
        CSSInlineStyle background = new CSSInlineStyle();
        background.add("background", "url(" + RequestCycle.get().urlFor(settings.getRightDownResource()) + ") no-repeat");
        background.add("width", res.getWidth() + "px");
        background.add("height", res.getHeight() + "px");
        return background.getStyle();
    }
}

