/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.yui.markup.html.slider;

import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.CSSPackageResource;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.image.Image;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.wicketstuff.yui.markup.html.contributor.yuiloader.YuiLoaderContributor;
import org.wicketstuff.yui.markup.html.contributor.yuiloader.YuiLoaderModule;
import org.wicketstuff.yui.markup.html.slider.YuiSliderSettings;

public abstract class YuiSlider
extends Panel {
    private static final long serialVersionUID = 1L;
    private static final String MODULE_NAME = "wicket_yui_slider";
    private static final ResourceReference MODULE_JS_REF = new ResourceReference(YuiSlider.class, "YuiSlider.js");
    private static final String[] MODULE_REQUIRES = new String[]{"slider", "animation"};
    YuiSliderSettings sliderSettings;
    WebMarkupContainer sliderLeftUp;
    WebMarkupContainer sliderRightDown;
    WebMarkupContainer sliderBg;
    WebMarkupContainer sliderThumb;

    public YuiSlider(String id, final YuiSliderSettings settings) {
        super(id);
        this.add(new IBehavior[]{CSSPackageResource.getHeaderContribution(YuiSlider.class, (String)"css/yuislider.css")});
        this.setOutputMarkupId(true);
        this.sliderSettings = settings;
        this.add(new IBehavior[]{YuiLoaderContributor.addModule(new YuiLoaderModule(MODULE_NAME, YuiLoaderModule.ModuleType.js, MODULE_JS_REF, MODULE_REQUIRES){
            private static final long serialVersionUID = 1L;

            public String onSuccessJS() {
                StringBuffer buffer = new StringBuffer();
                buffer.append("var " + YuiSlider.this.getSliderVar() + " = " + YuiSlider.this.getSliderTypJS() + "(\"" + YuiSlider.this.getSliderBgId() + "\",\"" + YuiSlider.this.getSliderThumbId() + "\"," + YuiSliderSettings.LEFT_DOWN + "," + settings.getLength() + "," + settings.getTickValue() + ");");
                buffer.append(YuiSlider.this.getSliderVar() + ".animate = true;");
                buffer.append(YuiSlider.this.getSliderVar() + ".setValue(" + settings.getStartValue() + ");");
                buffer.append(YuiSlider.this.getSliderVar() + ".subscribe(\"change\"," + YuiSlider.this.getOnChangeJSFunc() + ");");
                buffer.append(this.getOnClickJSFunc(YuiSlider.this.sliderLeftUp.getMarkupId(), YuiSlider.this.getSliderVar() + ".setValue(0);"));
                buffer.append(this.getOnClickJSFunc(YuiSlider.this.sliderRightDown.getMarkupId(), YuiSlider.this.getSliderVar() + ".setValue(" + settings.getLength() + ");"));
                return buffer.toString();
            }

            private String getOnClickJSFunc(String id, String jsFunc) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("YAHOO.util.Event.addListener(\"" + id + "\", \"click\", ");
                buffer.append("function(e) { " + jsFunc + "}");
                buffer.append(");");
                return buffer.toString();
            }
        })});
        if (settings == null) {
            // empty if block
        }
        Component[] componentArray = new Component[1];
        WebMarkupContainer yuislider = this.newSliderComponent("yuislider", "class", this.getCssClass());
        componentArray[0] = yuislider;
        this.add(componentArray);
        Component[] componentArray2 = new Component[1];
        this.sliderBg = this.newSliderComponent("yuislider-bg", this.getBackgroundStyle());
        componentArray2[0] = this.sliderBg;
        yuislider.add(componentArray2);
        Component[] componentArray3 = new Component[1];
        this.sliderThumb = this.newSliderComponent("yuislider-thumb", this.getThumbStyle());
        componentArray3[0] = this.sliderThumb;
        this.sliderBg.add(componentArray3);
        Component[] componentArray4 = new Component[1];
        this.sliderLeftUp = this.newSliderComponent("yuislider-bg-lu", this.getLeftUpStyle());
        componentArray4[0] = this.sliderLeftUp;
        yuislider.add(componentArray4);
        Component[] componentArray5 = new Component[1];
        this.sliderRightDown = this.newSliderComponent("yuislider-bg-rd", this.getRightDownStyle());
        componentArray5[0] = this.sliderRightDown;
        yuislider.add(componentArray5);
        Image thumbImg = new Image("thumbImg", settings.getThumbResource());
        this.sliderThumb.add(new Component[]{thumbImg});
    }

    private WebMarkupContainer newSliderComponent(String id, String style) {
        return this.newSliderComponent(id, "style", style);
    }

    private WebMarkupContainer newSliderComponent(String id, String attr, final String style) {
        WebMarkupContainer comp = new WebMarkupContainer(id);
        comp.add(new IBehavior[]{new AttributeModifier(attr, true, (IModel)new AbstractReadOnlyModel<String>(){
            private static final long serialVersionUID = 1L;

            public String getObject() {
                return style;
            }
        })});
        comp.setOutputMarkupId(true);
        return comp;
    }

    private String getSliderId() {
        return this.getMarkupId();
    }

    protected String getSliderVar() {
        return "var_" + this.getSliderId();
    }

    protected String getSliderThumbId() {
        return this.sliderThumb.getMarkupId();
    }

    protected String getSliderBgId() {
        return this.sliderBg.getMarkupId();
    }

    public YuiSliderSettings getSliderSettings() {
        return this.sliderSettings;
    }

    public void setSliderSettings(YuiSliderSettings sliderSettings) {
        this.sliderSettings = sliderSettings;
    }

    protected abstract String getSliderTypJS();

    protected abstract String getBackgroundStyle();

    protected abstract String getThumbStyle();

    protected abstract String getLeftUpStyle();

    protected abstract String getRightDownStyle();

    protected String getCssClass() {
        return "yuislider";
    }

    protected String getOnChangeJSFunc() {
        return "function(offsetFromStart) { }";
    }
}

