/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.yui.markup.html.slider;

import org.apache.wicket.RequestCycle;
import org.wicketstuff.yui.helper.CSSInlineStyle;
import org.wicketstuff.yui.helper.ImageResourceInfo;
import org.wicketstuff.yui.markup.html.slider.YuiSlider;
import org.wicketstuff.yui.markup.html.slider.YuiSliderSettings;

public class YuiVertSlider
extends YuiSlider {
    private static final long serialVersionUID = 1L;

    public YuiVertSlider(String id, YuiSliderSettings settings) {
        super(id, settings);
    }

    protected String getSliderTypJS() {
        return "YAHOO.widget.Slider.getVertSlider";
    }

    protected String getBackgroundStyle() {
        YuiSliderSettings settings = this.getSliderSettings();
        ImageResourceInfo bgInfo = new ImageResourceInfo(settings.getBackgroundResource());
        ImageResourceInfo thumbInfo = new ImageResourceInfo(settings.getThumbResource());
        int width = bgInfo.getWidth();
        int thumbHeight = thumbInfo.getHeight();
        int bgLength = settings.getLength();
        String height = Integer.toString(bgLength - thumbHeight);
        CSSInlineStyle background = new CSSInlineStyle();
        background.add("height", height + "px");
        background.add("width", width + "px");
        background.add("background", "url(" + RequestCycle.get().urlFor(settings.getBackgroundResource()) + ") repeat-y");
        return background.getStyle();
    }

    protected String getThumbStyle() {
        YuiSliderSettings settings = this.getSliderSettings();
        ImageResourceInfo thumbInfo = new ImageResourceInfo(settings.getThumbResource());
        CSSInlineStyle thumb = new CSSInlineStyle();
        thumb.add("height", thumbInfo.getHeight() + "px");
        thumb.add("top", 0 - thumbInfo.getHeight() + "px");
        return thumb.getStyle();
    }

    protected String getLeftUpStyle() {
        YuiSliderSettings settings = this.getSliderSettings();
        ImageResourceInfo leftUp = new ImageResourceInfo(settings.getLeftUpResource());
        CSSInlineStyle background = new CSSInlineStyle();
        background.add("background", "url(" + RequestCycle.get().urlFor(settings.getLeftUpResource()) + ") no-repeat");
        background.add("height", leftUp.getHeight() + "px");
        return background.getStyle();
    }

    protected String getRightDownStyle() {
        YuiSliderSettings settings = this.getSliderSettings();
        ImageResourceInfo rightDown = new ImageResourceInfo(settings.getRightDownResource());
        CSSInlineStyle background = new CSSInlineStyle();
        background.add("background", "url(" + RequestCycle.get().urlFor(settings.getRightDownResource()) + ") no-repeat");
        background.add("height", rightDown.getHeight() + "px");
        return background.getStyle();
    }

    protected String getCssClass() {
        return "yuislider-vert";
    }
}

