/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.yui.markup.html.sort;

import java.util.HashMap;
import java.util.List;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.behavior.StringHeaderContributor;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.template.PackagedTextTemplate;
import org.wicketstuff.yui.helper.YuiImage;
import org.wicketstuff.yui.markup.html.sort.SortSettings;

public class SortGroup
extends WebMarkupContainer {
    private static final long serialVersionUID = 1L;
    private String javaScriptId;
    private String mode;
    private List<YuiImage> sortList;
    private String id;
    private String valueId;

    public SortGroup(String id, SortSettings settings, final FormComponent element) {
        super(id);
        this.mode = settings.getMode();
        this.sortList = settings.getSortList();
        this.id = id;
        this.valueId = element.getId() + "_" + id;
        if (element != null) {
            element.add(new IBehavior[]{new AttributeModifier("id", true, (IModel)new AbstractReadOnlyModel(){
                private static final long serialVersionUID = 1L;

                public Object getObject() {
                    return element.getId() + "_" + SortGroup.this.javaScriptId;
                }
            })});
        }
        this.add(new Component[]{element});
    }

    protected String getJavaScriptComponentInitializationScript() {
        String sortValues = "";
        String sortIds = "";
        for (int i = 0; i < this.sortList.size(); ++i) {
            YuiImage yuiImage = this.sortList.get(i);
            if (sortValues.equals("") || sortValues == "") {
                sortValues = "'" + yuiImage.getDesc() + "'";
                sortIds = "'dd" + i + "_" + this.id + "'";
                continue;
            }
            sortValues = sortValues + ", '" + yuiImage.getDesc() + "'";
            sortIds = sortIds + ", 'dd" + i + "_" + this.id + "'";
        }
        PackagedTextTemplate template = new PackagedTextTemplate(SortGroup.class, "init.js");
        HashMap<String, String> variables = new HashMap<String, String>(4);
        variables.put("javaScriptId", this.javaScriptId);
        variables.put("mode", "YAHOO.util.DDM." + this.mode);
        variables.put("sortValues", sortValues);
        variables.put("sortIds", sortIds);
        variables.put("valueId", "'" + this.valueId + "'");
        template.interpolate(variables);
        return template.getString();
    }

    protected void onBeforeRender() {
        super.onBeforeRender();
        this.javaScriptId = this.getMarkupId();
        String js = "\n<script type=\"text/javascript\">" + this.getJavaScriptComponentInitializationScript() + "\n</script>\n";
        this.add(new IBehavior[]{new StringHeaderContributor(js)});
    }
}

