/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.yui.markup.html.sort;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.ResourceReference;
import org.wicketstuff.yui.helper.CSSInlineStyle;
import org.wicketstuff.yui.helper.ImageResourceInfo;
import org.wicketstuff.yui.helper.YuiImage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SortSettings
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int height;
    private List<CSSInlineStyle> imgStyleList = new ArrayList<CSSInlineStyle>();
    private String mode;
    private List<YuiImage> sortList;
    private int width;

    public static SortSettings getDefault(String mode, List<YuiImage> sortList) {
        SortSettings settings = new SortSettings();
        settings.setResources(mode, sortList);
        return settings;
    }

    public int getHeight() {
        return this.height;
    }

    public List<CSSInlineStyle> getImgStyleList() {
        return this.imgStyleList;
    }

    public String getMode() {
        return this.mode;
    }

    public List<YuiImage> getSortList() {
        return this.sortList;
    }

    public int getWidth() {
        return this.width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setImageResources(List<YuiImage> sortList) {
        for (int i = 0; i < sortList.size(); ++i) {
            YuiImage img = sortList.get(i);
            ResourceReference imgRR = new ResourceReference(SortSettings.class, img.getFileName());
            ImageResourceInfo imgInfo = new ImageResourceInfo(imgRR);
            int imgWidth = imgInfo.getWidth();
            int imgHeight = imgInfo.getHeight();
            CSSInlineStyle imgStyle = new CSSInlineStyle();
            imgStyle.add("background", "url(" + RequestCycle.get().urlFor(imgRR) + ")");
            imgStyle.add("width", imgWidth + "px");
            imgStyle.add("height", imgHeight + "px");
            imgStyle.add("top", img.getTop() + "px");
            imgStyle.add("left", img.getLeft() + "px");
            this.imgStyleList.add(imgStyle);
            this.width = imgWidth;
            this.height = imgHeight;
        }
    }

    public void setImgStyleList(List<CSSInlineStyle> imgStyleList) {
        this.imgStyleList = imgStyleList;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public void setResources(String mode, List<YuiImage> sortList) {
        this.setMode(mode);
        this.setSortList(sortList);
        this.setImageResources(sortList);
    }

    public void setSortList(List<YuiImage> sortList) {
        this.sortList = sortList;
    }

    public void setWidth(int width) {
        this.width = width;
    }
}

