/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.yui.markup.html.sortable;

import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.Request;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.Response;
import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.JavascriptPackageResource;
import org.apache.wicket.markup.html.resources.JavascriptResourceReference;
import org.wicketstuff.yui.markup.html.contributor.YuiHeaderContributor;
import org.wicketstuff.yui.markup.html.sortable.Draggable;

public abstract class Droppable
extends AbstractDefaultAjaxBehavior {
    private static final long serialVersionUID = 1L;
    private static final ResourceReference SORTABLELIST_JS = new JavascriptResourceReference(Droppable.class, "sortablelist.js");

    protected void onBind() {
        this.getComponent().setOutputMarkupId(true);
        this.getComponent().add(new IBehavior[]{YuiHeaderContributor.forModule("dragdrop")});
        this.getComponent().add(new IBehavior[]{YuiHeaderContributor.forModule("utilities")});
        this.getComponent().add(new IBehavior[]{JavascriptPackageResource.getHeaderContribution((ResourceReference)SORTABLELIST_JS)});
    }

    protected void onComponentRendered() {
        Response response = this.getComponent().getResponse();
        String groupId = this.getComponent().getMarkupId();
        final StringBuilder builder = new StringBuilder();
        this.getComponent().getPage().visitChildren((Component.IVisitor)new DraggableVisitor(){

            void visit(Draggable draggable) {
                if (builder.length() > 0) {
                    builder.append(',');
                }
                builder.append('\'');
                builder.append(draggable.getComponent().getMarkupId());
                builder.append('\'');
            }
        });
        response.write((CharSequence)"<script type=\"text/javascript\"><!--/*--><![CDATA[/*><!--*/\n");
        response.write((CharSequence)("YAHOO.util.Event.onDOMReady(Wicket.yui.SortableListApp.init,{groupId:'" + groupId + "',items:[" + builder + "], callbackUrl:'" + this.getCallbackUrl() + "'});"));
        response.write((CharSequence)"\n/*-->]]>*/</script>\n");
    }

    protected boolean accept(Draggable draggable) {
        return true;
    }

    protected void respond(final AjaxRequestTarget target) {
        Request request = this.getComponent().getRequest();
        final int index = Integer.parseInt(request.getParameter("dindex"));
        final String did = request.getParameter("did");
        this.getComponent().getPage().visitChildren((Component.IVisitor)new DraggableVisitor(){

            void visit(Draggable draggable) {
                if (draggable.getComponent().getMarkupId().equals(did)) {
                    Droppable.this.onDrop(target, draggable.getComponent(), index);
                }
            }
        });
    }

    public abstract void onDrop(AjaxRequestTarget var1, Component var2, int var3);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class DraggableVisitor
    implements Component.IVisitor<Component> {
        private DraggableVisitor() {
        }

        public Object component(Component component) {
            List behaviors = component.getBehaviors();
            for (int a = 0; a < behaviors.size(); ++a) {
                Draggable draggable;
                IBehavior behavior = (IBehavior)behaviors.get(a);
                if (!(behavior instanceof Draggable) || !Droppable.this.accept(draggable = (Draggable)behavior)) continue;
                this.visit(draggable);
                return Component.IVisitor.CONTINUE_TRAVERSAL_BUT_DONT_GO_DEEPER;
            }
            return Component.IVisitor.CONTINUE_TRAVERSAL;
        }

        abstract void visit(Draggable var1);
    }
}

