/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.yui.markup.html.tabs.dynamictabbedpanel;

import java.io.Serializable;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxFallbackLink;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.extensions.ajax.markup.html.AjaxEditableLabel;
import org.apache.wicket.extensions.ajax.markup.html.tabs.AjaxTabbedPanel;
import org.apache.wicket.extensions.markup.html.tabs.ITab;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.CSSPackageResource;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.list.Loop;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.wicketstuff.yui.behavior.dragdrop.YuiDDList;
import org.wicketstuff.yui.helper.CollectionsHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DynamicAjaxTabbedPanel
extends AjaxTabbedPanel {
    private String groupId;

    public DynamicAjaxTabbedPanel(String id, final List<ITab> tabs) {
        super(id, tabs);
        this.add(new IBehavior[]{CSSPackageResource.getHeaderContribution(DynamicAjaxTabbedPanel.class, (String)"res/DynamicAjaxTabbedPanel.css")});
        MarkupContainer tabContainer = (MarkupContainer)this.get("tabs-container");
        tabContainer.setOutputMarkupId(true);
        this.groupId = tabContainer.getMarkupId();
        tabContainer.add(new Component[]{new AjaxFallbackLink<String>("add", (IModel)new Model((Serializable)((Object)"add"))){

            public void onClick(AjaxRequestTarget target) {
                String label = DynamicAjaxTabbedPanel.this.getNewTabLabel();
                tabs.add(DynamicAjaxTabbedPanel.this.newTab(label));
                DynamicAjaxTabbedPanel.this.onAdd(target, label);
                target.addComponent((Component)DynamicAjaxTabbedPanel.this);
            }
        }});
        tabContainer.add(new Component[]{new AjaxFallbackLink<String>("remove", (IModel)new Model((Serializable)((Object)"remove"))){

            public void onClick(AjaxRequestTarget target) {
                DynamicAjaxTabbedPanel.this.onRemove(target, DynamicAjaxTabbedPanel.this.getSelectedTab());
                target.addComponent((Component)DynamicAjaxTabbedPanel.this);
            }
        }});
    }

    protected String getNewTabLabel() {
        return "tab " + (this.getTabs().size() + 1);
    }

    protected void onBeforeRender() {
        if (this.getTabs().isEmpty()) {
            this.getTabs().add(this.newTab(this.getNewTabLabel()));
        }
        if (this.getSelectedTab() == this.getTabs().size()) {
            this.setSelectedTab(this.getTabs().size() - 1);
        }
        super.onBeforeRender();
    }

    protected abstract ITab newTab(String var1);

    protected WebMarkupContainer newLink(String linkId, final int index) {
        return new AjaxFallbackLink(linkId){

            public void onClick(AjaxRequestTarget target) {
                if (DynamicAjaxTabbedPanel.this.getSelectedTab() != index) {
                    DynamicAjaxTabbedPanel.this.setSelectedTab(index);
                    if (target != null) {
                        target.addComponent((Component)DynamicAjaxTabbedPanel.this);
                    }
                    DynamicAjaxTabbedPanel.this.onAjaxUpdate(target);
                }
            }
        };
    }

    protected Component newTitle(String titleId, final IModel<?> titleModel, final int index) {
        return new AjaxEditableLabel<String>(titleId, titleModel){

            protected String getLabelAjaxEvent() {
                return "ondblclick";
            }

            protected void onSubmit(AjaxRequestTarget target) {
                super.onSubmit(target);
                DynamicAjaxTabbedPanel.this.onLabelChanged(target, index, titleModel.getObject().toString());
            }
        };
    }

    protected String getTabContainerCssClass() {
        return "dyn-tab-row";
    }

    protected Loop.LoopItem newTabContainer(final int tabIndex) {
        return new Loop.LoopItem(tabIndex){
            private static final long serialVersionUID = 1L;

            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                String cssClass = (String)tag.getString("class");
                if (cssClass == null) {
                    cssClass = " ";
                }
                cssClass = cssClass + " tab" + this.getIteration();
                if (this.getIteration() == DynamicAjaxTabbedPanel.this.getSelectedTab()) {
                    cssClass = cssClass + " selected";
                }
                if (this.getIteration() == DynamicAjaxTabbedPanel.this.getTabs().size() - 1) {
                    cssClass = cssClass + " last";
                }
                tag.put("class", (CharSequence)cssClass.trim());
            }

            public boolean isVisible() {
                return ((ITab)DynamicAjaxTabbedPanel.this.getTabs().get(tabIndex)).isVisible();
            }

            protected void onBeforeRender() {
                super.onBeforeRender();
                this.add(new IBehavior[]{new YuiDDList(DynamicAjaxTabbedPanel.this.groupId){

                    protected void onDrop(AjaxRequestTarget target, int index, Component destItem) {
                        DynamicAjaxTabbedPanel.this.onDrop(target, this.getIteration(), index);
                    }
                }});
            }
        };
    }

    protected void onAdd(AjaxRequestTarget target, String label) {
    }

    protected void onRemove(AjaxRequestTarget target, int selectedTab) {
        this.getTabs().remove(this.getSelectedTab());
    }

    protected void onDrop(AjaxRequestTarget target, int fromInd, int toInd) {
        CollectionsHelper.rotateInto(this.getTabs(), fromInd, toInd);
        target.addComponent((Component)this);
    }

    protected void onLabelChanged(AjaxRequestTarget target, int index, String label) {
    }
}

