/*
 * Decompiled with CFR 0.152.
 */
package org.wikbook.codesource;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.wikbook.codesource.CodeSourceException;
import org.wikbook.codesource.Signature;

public final class MemberKey {
    final String name;
    final Signature signature;

    public static MemberKey createField(String name) {
        return new MemberKey(name, null);
    }

    public static MemberKey createMethod(String name, String ... parameterTypes) {
        return new MemberKey(name, new Signature(Arrays.asList(parameterTypes)));
    }

    public static MemberKey parse(String member) {
        Pattern pattern = Pattern.compile("^\\s*([^\\(\\)]+)(\\(([^\\(\\)]*)?\\))?\\s*$");
        Matcher matcher = pattern.matcher(member);
        if (!matcher.matches()) {
            throw new CodeSourceException(member + " is not a member");
        }
        Signature signature = null;
        String name = matcher.group(1);
        String signatureString = matcher.group(3);
        if (signatureString != null) {
            List<String> parameterTypes = Collections.emptyList();
            if ((signatureString = signatureString.trim()).length() > 0) {
                parameterTypes = Arrays.asList(signatureString.split("\\s*,\\s*"));
            }
            signature = new Signature(parameterTypes);
        }
        return new MemberKey(name, signature);
    }

    MemberKey(String name, Signature signature) {
        if (name == null) {
            throw new NullPointerException();
        }
        this.name = name;
        this.signature = signature;
    }

    public int hashCode() {
        return this.name.hashCode() ^ this.signature.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof MemberKey) {
            MemberKey that = (MemberKey)o;
            return this.name.equals(that.name) && (this.signature == null ? that.signature == null : this.signature.equals(that.signature));
        }
        return false;
    }

    public String toString() {
        return "MethodKey[name=" + this.name + ",signature=" + this.signature + "]";
    }
}

