/*
 * Decompiled with CFR 0.152.
 */
package org.wikbook.codesource;

import java.io.InputStream;
import java.util.Collection;
import org.wikbook.codesource.CodeSourceBuilderContext;
import org.wikbook.codesource.CodeSourceException;
import org.wikbook.codesource.CompilationUnitVisitor;
import org.wikbook.codesource.TypeSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodeSourceBuilder {
    final CodeSourceBuilderContext context;

    public CodeSourceBuilder(CodeSourceBuilderContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        this.context = context;
    }

    public CodeSourceBuilder() {
        this(new CodeSourceBuilderContext(){

            public InputStream getResource(String path) {
                return Thread.currentThread().getContextClassLoader().getResourceAsStream(path);
            }
        });
    }

    public TypeSource buildClass(String fqn) throws CodeSourceException {
        Collection<TypeSource> types = this.buildCompilationUnit(fqn.replace(".", "/") + ".java");
        for (TypeSource type : types) {
            if (!type.getName().equals(fqn)) continue;
            return type;
        }
        return null;
    }

    public Collection<TypeSource> buildCompilationUnit(String compilationUnitPath) throws CodeSourceException {
        if (compilationUnitPath == null) {
            throw new NullPointerException();
        }
        try {
            CompilationUnitVisitor visitor = new CompilationUnitVisitor(this);
            CompilationUnitVisitor.Visit visit = visitor.visit(compilationUnitPath);
            return visit.types;
        }
        catch (Exception e) {
            throw new CodeSourceException(e);
        }
    }
}

