/*
 * Decompiled with CFR 0.152.
 */
package org.wikbook.text;

import org.wikbook.text.Position;

public class Clip {
    private final Position from;
    private final Position to;

    public static Clip get(Position from, Position to) {
        return new Clip(from, to);
    }

    public static Clip get(int fromLine, int fromColumn, int toLine, int toColumn) {
        return new Clip(Position.get(fromLine, fromColumn), Position.get(toLine, toColumn));
    }

    private Clip(Position from, Position to) {
        if (from == null) {
            throw new NullPointerException();
        }
        if (to == null) {
            throw new NullPointerException();
        }
        this.from = from;
        this.to = to;
    }

    public Position getRelative(Position absolute) {
        if (absolute == null) {
            throw new NullPointerException();
        }
        if (this.contains(absolute)) {
            return Position.get(absolute.line - this.from.line, absolute.column);
        }
        return null;
    }

    public boolean contains(Position position) {
        if (position == null) {
            throw new NullPointerException();
        }
        if (position.line < this.from.line || position.line > this.to.line) {
            return false;
        }
        if (position.line == this.from.line) {
            return position.column >= this.from.column;
        }
        if (position.line == this.to.line) {
            return position.column < this.to.column;
        }
        return true;
    }

    public Position getFrom() {
        return this.from;
    }

    public Position getTo() {
        return this.to;
    }
}

