/*
 * Decompiled with CFR 0.152.
 */
package org.wikbook.model.content.block;

import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.wikbook.model.content.block.BlockElement;
import org.wikbook.model.content.block.CodeLanguage;
import org.wikbook.xml.ElementEmitter;
import org.wikbook.xml.OutputFormat;
import org.wikbook.xml.XML;
import org.wikbook.xml.XMLEmitter;

public class ProgramListingElement
extends BlockElement {
    private final String language;
    private final Integer indent;
    private final String content;

    public ProgramListingElement(String language, Integer indent, String content) {
        this.language = language;
        this.indent = indent;
        this.content = content;
    }

    public void writeTo(XMLEmitter xml) {
        ElementEmitter programListingXML = xml.element("programlisting");
        CodeLanguage codeLanguage = CodeLanguage.UNKNOWN;
        if (this.language != null) {
            if ("java".equalsIgnoreCase(this.language)) {
                codeLanguage = CodeLanguage.JAVA;
            } else if ("xml".equalsIgnoreCase(this.language)) {
                codeLanguage = CodeLanguage.XML;
            }
        }
        String bilto = this.content;
        switch (codeLanguage) {
            case XML: {
                if (this.indent != null) {
                    try {
                        Transformer transformer = XML.createTransformer(new OutputFormat(this.indent, true));
                        StringWriter writer = new StringWriter();
                        transformer.transform(new StreamSource(new StringReader(this.content)), new StreamResult(writer));
                        bilto = writer.toString();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        bilto = "Exception occured, see logs";
                    }
                }
                programListingXML.content(bilto, true);
                break;
            }
            case UNKNOWN: {
                programListingXML.content(bilto, true);
                break;
            }
            case JAVA: {
                programListingXML.content(bilto);
            }
        }
    }
}

