/*
 * Decompiled with CFR 0.152.
 */
package org.wikbook.core.model.structural;

import org.wikbook.core.model.DocbookElement;
import org.wikbook.core.model.ElementContainer;
import org.wikbook.core.model.content.ContentElement;
import org.wikbook.core.model.content.ContentElementContainer;
import org.wikbook.core.model.content.inline.AnchorElement;
import org.wikbook.core.model.content.inline.InlineElement;
import org.wikbook.core.model.structural.StructuralElement;
import org.wikbook.core.xml.ElementEmitter;
import org.wikbook.core.xml.XMLEmitter;

public class ComponentElement
extends StructuralElement {
    private boolean doTitle;
    protected ElementContainer<InlineElement> title;
    protected ContentElementContainer content = null;
    protected ElementContainer<ComponentElement> components = null;
    protected String id;
    protected int level = 0;

    public void beginTitle() {
        this.doTitle = true;
    }

    public void endTitle() {
        this.doTitle = false;
    }

    public boolean append(DocbookElement elt) {
        if (this.doTitle) {
            if (this.title == null) {
                this.title = new ElementContainer<InlineElement>(InlineElement.class);
            }
            if (elt instanceof AnchorElement) {
                this.id = ((AnchorElement)elt).getId();
                return true;
            }
            return this.title.append(elt);
        }
        if (elt instanceof ContentElement) {
            if (this.components != null) {
                throw new AssertionError();
            }
            if (this.content == null) {
                this.content = new ContentElementContainer();
            }
            return this.content.append(elt);
        }
        if (elt instanceof ComponentElement) {
            if (this.components == null) {
                this.components = new ElementContainer<ComponentElement>(ComponentElement.class);
            }
            ComponentElement componentElt = (ComponentElement)elt;
            componentElt.level = this.level + 1;
            return this.components.append(elt);
        }
        return false;
    }

    public void writeTo(XMLEmitter xml) {
        ElementEmitter chapterXML = xml.element(this.level == 0 ? "chapter" : "section");
        if (this.id != null) {
            chapterXML.withAttribute("id", this.id);
        }
        if (this.title != null) {
            this.title.writeTo(chapterXML.element("title"));
        }
        if (this.content != null) {
            this.content.writeTo(chapterXML);
        }
        if (this.components != null) {
            this.components.writeTo(chapterXML);
        }
    }
}

