/*
 * Decompiled with CFR 0.152.
 */
package org.wikbook.core.model.content.block;

import java.util.EnumMap;
import org.wikbook.core.model.DocbookElement;
import org.wikbook.core.model.ElementContainer;
import org.wikbook.core.model.content.block.BlockElement;
import org.wikbook.core.model.content.block.ListItemElement;
import org.wikbook.core.model.content.block.ListKind;
import org.wikbook.core.xml.ElementEmitter;
import org.wikbook.core.xml.XMLEmitter;

public class ListElement
extends BlockElement {
    private static final EnumMap<ListKind, String> ListKindMap = new EnumMap(ListKind.class);
    private static final EnumMap<ListKind, String> styleMap = new EnumMap(ListKind.class);
    private final ListKind kind;
    private final ElementContainer<ListItemElement> items;
    private final String style;

    public ListElement(ListKind kind, String style) {
        this.kind = kind;
        this.items = new ElementContainer<ListItemElement>(ListItemElement.class);
        this.style = style;
    }

    public ListKind getKind() {
        return this.kind;
    }

    public boolean append(DocbookElement elt) {
        return this.items.append(elt);
    }

    public void writeTo(XMLEmitter xml) {
        ElementEmitter listXML = xml.element(ListKindMap.get((Object)this.kind));
        if (this.style != null) {
            listXML.withAttribute(styleMap.get((Object)this.kind), this.style);
        }
        this.items.writeTo(listXML);
    }

    static {
        ListKindMap.put(ListKind.BULLETED, "itemizedlist");
        ListKindMap.put(ListKind.NUMBERED, "orderedlist");
        styleMap.put(ListKind.BULLETED, "mark");
        styleMap.put(ListKind.NUMBERED, "numeration");
    }
}

