/*
 * Decompiled with CFR 0.152.
 */
package org.wikbook.core.model.content.block.table;

import java.util.Iterator;
import org.wikbook.core.model.DocbookElement;
import org.wikbook.core.model.ElementContainer;
import org.wikbook.core.model.content.block.BlockElement;
import org.wikbook.core.model.content.block.table.TableRowElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableElement
extends BlockElement {
    private ElementContainer<TableRowElement> structure = new ElementContainer<TableRowElement>(TableRowElement.class);
    private final String title;

    public TableElement(String title) {
        this.title = title;
    }

    public int getColumnMaxSize() {
        int columnCount = 0;
        for (TableRowElement row : this.structure) {
            columnCount = Math.max(columnCount, row.getCells().getSize());
        }
        return columnCount;
    }

    public int getBodyIndex() {
        int bodyIndex = 0;
        for (TableRowElement row : this.structure) {
            if (!row.isHead()) break;
            ++bodyIndex;
        }
        return bodyIndex;
    }

    public int getFooterIndex() {
        int bodyIndex = this.getBodyIndex();
        int footerIndex = this.getRowSize();
        Iterator<TableRowElement> i = this.structure.reverseIterator();
        while (i.hasNext()) {
            TableRowElement row = i.next();
            if (footerIndex <= bodyIndex || !row.isHead()) break;
            --footerIndex;
        }
        return footerIndex;
    }

    public int getRowSize() {
        return this.structure.getSize();
    }

    public Iterable<TableRowElement> getHeaders() {
        return this.structure.iterator(0, this.getBodyIndex());
    }

    public Iterable<TableRowElement> getBody() {
        return this.structure.iterator(this.getBodyIndex(), this.getFooterIndex());
    }

    public Iterable<TableRowElement> getFooters() {
        return this.structure.iterator(this.getFooterIndex(), this.getRowSize());
    }

    public String getTitle() {
        return this.title;
    }

    @Override
    public boolean append(DocbookElement elt) {
        return this.structure.append(elt);
    }
}

