/*
 * Decompiled with CFR 0.152.
 */
package org.wikbook.core.model.structural;

import org.wikbook.core.model.DocbookElement;
import org.wikbook.core.model.ElementContainer;
import org.wikbook.core.model.content.ContentElement;
import org.wikbook.core.model.content.inline.AnchorElement;
import org.wikbook.core.model.content.inline.InlineElement;
import org.wikbook.core.model.structural.StructuralElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentElement
extends StructuralElement {
    private boolean doTitle;
    protected ElementContainer<InlineElement> title;
    protected ElementContainer<ContentElement> content = null;
    protected ElementContainer<ComponentElement> components = null;
    protected String id;
    protected int level = 0;

    public String getId() {
        return this.id;
    }

    public int getLevel() {
        return this.level;
    }

    public ElementContainer<InlineElement> getTitle() {
        return this.title;
    }

    public ElementContainer<ComponentElement> getComponents() {
        return this.components;
    }

    public ElementContainer<ContentElement> getContent() {
        return this.content;
    }

    public void beginTitle() {
        this.doTitle = true;
    }

    public void endTitle() {
        this.doTitle = false;
    }

    @Override
    public boolean append(DocbookElement elt) {
        if (this.doTitle) {
            if (this.title == null) {
                this.title = new ElementContainer<InlineElement>(InlineElement.class);
            }
            if (elt instanceof AnchorElement) {
                this.id = ((AnchorElement)elt).getId();
                return true;
            }
            return this.title.append(elt);
        }
        if (elt instanceof ContentElement) {
            if (this.components != null) {
                throw new AssertionError();
            }
            if (this.content == null) {
                this.content = new ElementContainer<ContentElement>(ContentElement.class);
            }
            return this.content.append(elt);
        }
        if (elt instanceof ComponentElement) {
            if (this.components == null) {
                this.components = new ElementContainer<ComponentElement>(ComponentElement.class);
            }
            ComponentElement componentElt = (ComponentElement)elt;
            componentElt.level = this.level + 1;
            return this.components.append(elt);
        }
        return false;
    }
}

