/*
 * Decompiled with CFR 0.152.
 */
package org.wikbook.core.model.content.block;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.wikbook.core.ResourceType;
import org.wikbook.core.WikbookException;
import org.wikbook.core.codesource.CodeContext;
import org.wikbook.core.codesource.CodeProcessor;
import org.wikbook.core.model.DocbookBuilderContext;
import org.wikbook.core.model.DocbookElement;
import org.wikbook.core.model.ElementContainer;
import org.wikbook.core.model.content.block.BlockElement;
import org.wikbook.core.model.content.block.CalloutElement;
import org.wikbook.core.model.content.block.DocumentFormatterFilter;
import org.wikbook.core.model.content.block.LanguageSyntax;
import org.wikbook.core.xml.OutputFormat;
import org.wikbook.core.xml.XML;
import org.wikbook.text.Position;
import org.wikbook.text.TextArea;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProgramListingElement
extends BlockElement {
    private final ElementContainer<CalloutElement> callouts;
    private final LanguageSyntax languageSyntax;
    private final Integer indent;
    private final String content;
    private final DocbookBuilderContext context;
    private final boolean highlightCode;
    private String listing;
    private final DocumentBuilder documentBuilder;
    private final XPath xpath;

    public ProgramListingElement(DocbookBuilderContext context, LanguageSyntax languageSyntax, Integer indent, String content, boolean highlightCode) {
        DocumentBuilder documentBuilder;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setIgnoringElementContentWhitespace(true);
        dbf.setCoalescing(true);
        dbf.setNamespaceAware(true);
        dbf.setXIncludeAware(false);
        try {
            documentBuilder = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new WikbookException(e);
        }
        this.context = context;
        this.languageSyntax = languageSyntax;
        this.indent = indent;
        this.content = content;
        this.highlightCode = highlightCode;
        this.callouts = new ElementContainer<CalloutElement>(CalloutElement.class);
        this.documentBuilder = documentBuilder;
        this.xpath = XPathFactory.newInstance().newXPath();
    }

    public String getListing() {
        return this.listing;
    }

    public LanguageSyntax getLanguageSyntax() {
        return this.languageSyntax;
    }

    public boolean isHighlightCode() {
        return this.highlightCode;
    }

    public ElementContainer<CalloutElement> getCallouts() {
        return this.callouts;
    }

    private void performIncludes(Element elt) {
        if ("urn:wikbook:internal".equals(elt.getNamespaceURI()) && "include".equals(elt.getLocalName())) {
            String hrefAttr = elt.getAttribute("href");
            List<Node> replacementElts = null;
            try {
                URL url = this.assertContextualized().resolveResource(ResourceType.XML, hrefAttr);
                if (url != null) {
                    Document includedDoc = this.documentBuilder.parse(url.openStream());
                    if (elt.hasAttribute("xpath")) {
                        String xpathAttr = elt.getAttribute("xpath");
                        XPathExpression xpathExpr = this.xpath.compile(xpathAttr);
                        replacementElts = new ArrayList<Element>();
                        NodeList resolvedNodes = (NodeList)xpathExpr.evaluate(includedDoc, XPathConstants.NODESET);
                        for (int i = 0; i < resolvedNodes.getLength(); ++i) {
                            Node resolvedNode = resolvedNodes.item(i);
                            if (resolvedNode.getNodeType() == 2) continue;
                            replacementElts.add((Element)elt.getOwnerDocument().importNode(resolvedNode, true));
                        }
                    } else {
                        Element includedElt = includedDoc.getDocumentElement();
                        replacementElts = Collections.singletonList(elt.getOwnerDocument().importNode(includedElt, true));
                    }
                }
            }
            catch (Exception e) {
                this.context.onValidationError(e);
                Element errorElt = elt.getOwnerDocument().createElement("wikbook:error");
                Text text = elt.getOwnerDocument().createTextNode(e.getMessage());
                errorElt.appendChild(text);
                replacementElts = Collections.singletonList(errorElt);
            }
            for (Node replacement : replacementElts) {
                elt.getParentNode().insertBefore(replacement, elt);
            }
            elt.getParentNode().removeChild(elt);
        } else {
            for (Element childElt : XML.elements(elt)) {
                this.performIncludes(childElt);
            }
        }
    }

    public void process() {
        String bilto;
        switch (this.languageSyntax) {
            case XML: {
                try {
                    String data = "<root xmlns:wikbook=\"urn:wikbook:internal\">" + this.content.replaceAll("<\\?xml.*\\?>", "") + "</root>";
                    Document doc = this.documentBuilder.parse(new InputSource(new StringReader(data)));
                    Element docElt = doc.getDocumentElement();
                    this.performIncludes(docElt);
                    if (this.indent != null) {
                        XML.removeWhiteSpace(docElt);
                    }
                    StringWriter writer = new StringWriter();
                    TransformerHandler serializer = XML.createTransformerHandler(new OutputFormat(this.indent, false));
                    serializer.setResult(new StreamResult(writer));
                    Transformer domToSAX = TransformerFactory.newInstance().newTransformer();
                    domToSAX.transform(new DOMSource(doc), new SAXResult(new DocumentFormatterFilter(serializer)));
                    data = writer.toString();
                    TextArea ta = new TextArea(data);
                    ta.trimLeft();
                    bilto = ta.getText();
                }
                catch (Exception e) {
                    this.context.onValidationError(e);
                    bilto = "Exception occured, see logs";
                }
                break;
            }
            case JAVA: {
                CodeContextImpl ctx = new CodeContextImpl();
                new CodeProcessor().parse(this.content, ctx);
                for (Map.Entry callout : ctx.callouts.entrySet()) {
                    if (((Callout)callout.getValue()).text == null) continue;
                    CalloutElement calloutElt = new CalloutElement(((Callout)callout.getValue()).ids, ((Callout)callout.getValue()).text);
                    this.assertContextualized().build(new StringReader(((Callout)callout.getValue()).text), calloutElt);
                    this.merge(calloutElt);
                }
                bilto = ctx.sb.toString();
                break;
            }
            default: {
                bilto = this.content;
            }
        }
        this.listing = bilto;
    }

    @Override
    public boolean append(DocbookElement elt) {
        return this.callouts.append(elt);
    }

    private static class Callout {
        private String text;
        private final LinkedHashMap<String, Position> ids = new LinkedHashMap();

        private Callout() {
        }
    }

    private class CodeContextImpl
    implements CodeContext {
        private final StringBuilder sb = new StringBuilder();
        private final TreeMap<String, Callout> callouts = new TreeMap();
        private final Random random = new Random();

        private CodeContextImpl() {
        }

        public void writeContent(String content) {
            this.sb.append(content);
        }

        public void writeCallout(String index) {
            String coId = "" + Math.abs(this.random.nextLong());
            TextArea ta = new TextArea(this.sb.toString());
            Position pos = ta.position(this.sb.length());
            Callout callout = this.callouts.get(index);
            if (callout == null) {
                callout = new Callout();
                this.callouts.put(index, callout);
            }
            this.writeContent(" ");
            callout.ids.put(coId, pos);
        }

        public void setCallout(String index, String text) {
            Callout callout = this.callouts.get(index);
            if (callout == null) {
                callout = new Callout();
                this.callouts.put(index, callout);
            }
            callout.text = text;
        }

        public InputStream resolveResources(String id) throws IOException {
            List<URL> list = ProgramListingElement.this.context.resolveResources(ResourceType.JAVA, id);
            if (list.size() > 0) {
                return list.get(0).openStream();
            }
            return null;
        }
    }
}

