/*
 * Decompiled with CFR 0.152.
 */
package org.wikbook.core.model;

import org.wikbook.core.model.DocbookElementContext;
import org.wikbook.core.model.content.inline.InlineElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DocbookElement {
    DocbookElementContext context;
    private DocbookElement currentChildElt;
    private boolean inlineAppended = false;

    protected DocbookElement(DocbookElementContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        this.context = context;
    }

    protected DocbookElement() {
        this.context = null;
    }

    protected final DocbookElementContext assertContextualized() {
        if (this.context == null) {
            throw new IllegalStateException("No context");
        }
        return this.context;
    }

    public final void close() {
        DocbookElement currentElt = this.currentChildElt;
        this.currentChildElt = null;
        if (currentElt != null) {
            if (!this.append(currentElt)) {
                throw new AssertionError((Object)("Could not append element " + currentElt.getClass().getName() + " to element " + this.getClass().getName()));
            }
            currentElt.close();
        }
    }

    private DocbookElement current(boolean remove) {
        DocbookElement currentElt = this.currentChildElt;
        if (currentElt != null) {
            DocbookElement nextElt = currentElt.current(remove);
            if (nextElt == null) {
                if (remove) {
                    this.currentChildElt = null;
                    currentElt.context = null;
                }
            } else {
                currentElt = nextElt;
            }
        }
        return currentElt;
    }

    public final Class<DocbookElement> getType() {
        return this.getClass();
    }

    public final DocbookElement peek() {
        return this.current(false);
    }

    public final DocbookElement pop() {
        return this.current(true);
    }

    public final <E extends DocbookElement> E push(E elt) {
        if (this.context == null) {
            throw new IllegalStateException("No context");
        }
        if (elt.context != null) {
            throw new IllegalArgumentException("Already has a parent");
        }
        DocbookElement currentElt = this.currentChildElt;
        if (currentElt == null) {
            this.currentChildElt = elt;
            elt.context = this.context;
            return elt;
        }
        return currentElt.push(elt);
    }

    public final void merge() {
        this.merge(this.pop());
    }

    public final <E extends DocbookElement> E merge(E elt) {
        if (elt == null) {
            throw new NullPointerException();
        }
        if (this.context == null) {
            throw new IllegalStateException("No context");
        }
        if (elt.context != null) {
            throw new IllegalArgumentException("Already has a parent");
        }
        DocbookElement appendedElt = this.peek();
        if (appendedElt == null) {
            appendedElt = this;
        }
        if (!appendedElt.append(elt)) {
            throw new AssertionError((Object)("Could not append element " + elt + " to element " + appendedElt));
        }
        if (elt instanceof InlineElement) {
            appendedElt.inlineAppended = true;
        }
        elt.context = this.context;
        return elt;
    }

    public boolean hasInlineAppended() {
        return this.inlineAppended;
    }

    public boolean append(DocbookElement elt) {
        return false;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[]";
    }
}

