/*
 * Decompiled with CFR 0.152.
 */
package org.wikbook.xwiki;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.wikbook.core.ResourceType;
import org.wikbook.core.Utils;
import org.wikbook.core.WikbookException;
import org.wikbook.core.WikletContext;
import org.wikbook.xwiki.IncludeBlock;
import org.wikbook.xwiki.PropertyFilter;
import org.wikbook.xwiki.Substitution;
import org.xwiki.component.embed.EmbeddableComponentManager;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.HeaderBlock;
import org.xwiki.rendering.block.MacroBlock;
import org.xwiki.rendering.block.SectionBlock;
import org.xwiki.rendering.block.VerbatimBlock;
import org.xwiki.rendering.block.WordBlock;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.listener.HeaderLevel;
import org.xwiki.rendering.parser.ParseException;
import org.xwiki.rendering.parser.Parser;
import org.xwiki.rendering.renderer.BlockRenderer;
import org.xwiki.rendering.renderer.printer.DefaultWikiPrinter;
import org.xwiki.rendering.renderer.printer.WikiPrinter;
import org.xwiki.rendering.syntax.Syntax;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class WikiLoader {
    private final WikletContext context;
    private final EmbeddableComponentManager ecm;

    public WikiLoader(WikletContext context) throws WikbookException {
        EmbeddableComponentManager ecm = new EmbeddableComponentManager();
        ecm.initialize(Thread.currentThread().getContextClassLoader());
        this.context = context;
        this.ecm = ecm;
    }

    public Block load(String id, String syntaxId) throws WikbookException {
        return this.load(id, syntaxId, 0);
    }

    public Block load(Reader reader, String syntaxId) throws WikbookException {
        return this.load(reader, syntaxId, 0);
    }

    private Block load(String id, String syntaxId, int baseLevel) throws WikbookException {
        try {
            Reader reader = this._load(id);
            return this.load(reader, syntaxId, baseLevel);
        }
        catch (IOException e) {
            throw new WikbookException((Throwable)e);
        }
    }

    private Block load(Reader reader, String syntaxId, int baseLevel) throws WikbookException {
        try {
            XDOM xdom;
            if (syntaxId == null) {
                syntaxId = Syntax.XWIKI_2_0.toIdString();
            }
            String s = Utils.read((Reader)reader);
            s = new PropertyFilter(){

                protected String resolveProperty(String propertyname) {
                    return WikiLoader.this.context.getProperty(propertyname);
                }
            }.filter(s);
            if ("verbatim".equals(syntaxId)) {
                xdom = new XDOM(new ArrayList());
                xdom.addChild((Block)new VerbatimBlock(s, false));
            } else {
                List<Substitution> substitutions;
                Parser parser = (Parser)this.ecm.lookup(Parser.class, syntaxId);
                xdom = parser.parse((Reader)new StringReader(s));
                if (baseLevel > 0) {
                    for (HeaderBlock header : xdom.getChildrenByType(HeaderBlock.class, true)) {
                        int l = baseLevel + header.getLevel().getAsInt();
                        HeaderBlock nheader = new HeaderBlock(header.getChildren(), HeaderLevel.parseInt((int)l), header.getParameters(), header.getId());
                        header.getParent().replaceChild((Block)nheader, (Block)header);
                    }
                }
                if ((substitutions = this.visit((Block)xdom, syntaxId)).size() > 0) {
                    for (Substitution substitution : substitutions) {
                        substitution.src.getParent().replaceChild(substitution.dst, substitution.src);
                    }
                    DefaultWikiPrinter printer = new DefaultWikiPrinter();
                    BlockRenderer substitutionRenderer = (BlockRenderer)this.ecm.lookup(BlockRenderer.class, Syntax.XWIKI_2_0.toIdString());
                    substitutionRenderer.render((Block)xdom, (WikiPrinter)printer);
                    Parser substitutionParser = (Parser)this.ecm.lookup(Parser.class, Syntax.XWIKI_2_0.toIdString());
                    xdom = substitutionParser.parse((Reader)new StringReader(printer.toString()));
                }
            }
            return new IncludeBlock(syntaxId, xdom.getChildren());
        }
        catch (IOException e) {
            throw new WikbookException((Throwable)e);
        }
        catch (ComponentLookupException e) {
            throw new WikbookException((Throwable)e);
        }
        catch (ParseException e) {
            throw new WikbookException((Throwable)e);
        }
    }

    private Reader _load(String id) throws IOException {
        URL main = this.context.resolveResource(ResourceType.WIKI, id);
        if (main == null) {
            throw new IOException("Could not load wiki document: " + id);
        }
        return Utils.read((URL)main);
    }

    private List<Substitution> visit(Block block, String currentSyntaxId) {
        return this.visit(block, 0, currentSyntaxId);
    }

    private List<Substitution> visit(Block block, int level, String currentSyntaxId) {
        if (block instanceof MacroBlock) {
            String value;
            String name;
            MacroBlock macro = (MacroBlock)block;
            String id = macro.getId();
            if ("include".equals(id)) {
                String includedId = macro.getParameter("document");
                String syntaxId = macro.getParameter("syntax");
                if (syntaxId == null) {
                    syntaxId = currentSyntaxId;
                }
                LinkedList<Substitution> list = new LinkedList<Substitution>();
                list.add(new Substitution(block, this.load(includedId, syntaxId, level)));
                return list;
            }
            if (id.startsWith("property.") && (name = id.substring("property.".length())) != null && (value = this.context.getProperty(name)) != null) {
                LinkedList<Substitution> list = new LinkedList<Substitution>();
                list.add(new Substitution(block, (Block)new WordBlock(value)));
                return list;
            }
        } else if (block instanceof SectionBlock) {
            ++level;
        }
        LinkedList<Substitution> substitutions = new LinkedList<Substitution>();
        for (Block child : block.getChildren()) {
            List<Substitution> childSubstitutions = this.visit(child, level, currentSyntaxId);
            if (childSubstitutions.size() <= 0) continue;
            substitutions.addAll(childSubstitutions);
        }
        return substitutions;
    }
}

