/*
 * Decompiled with CFR 0.152.
 */
package org.wikbook.xwiki;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.wikbook.core.ResourceType;
import org.wikbook.core.ValidationMode;
import org.wikbook.xwiki.AbstractXDOMDocbookBuilderContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleXDOMDocbookBuilderContext
extends AbstractXDOMDocbookBuilderContext {
    private final File base;
    private final Map<String, String> properties;
    private boolean highlightCode;
    private boolean emitDoctype;
    private ValidationMode validationMode;
    private String charsetName;

    public SimpleXDOMDocbookBuilderContext(File base) {
        if (base == null) {
            throw new NullPointerException("No null base directory accepted");
        }
        this.base = base;
        this.properties = new HashMap<String, String>();
        this.emitDoctype = true;
        this.highlightCode = true;
        this.validationMode = ValidationMode.STRICT;
        this.charsetName = "UTF-8";
    }

    public ValidationMode getValidationMode() {
        return this.validationMode;
    }

    public void log(String msg) {
        System.out.println(msg);
    }

    public void setValidationMode(ValidationMode validationMode) {
        this.validationMode = validationMode;
    }

    public String getProperty(String propertyName) {
        return this.properties.get(propertyName);
    }

    public void setProperty(String propertyName, String propertyValue) {
        if (this.properties != null) {
            this.properties.put(propertyName, propertyValue);
        } else {
            this.properties.remove(propertyName);
        }
    }

    public void removeProperty(String propertyName) {
        this.setProperty(propertyName, null);
    }

    @Override
    public List<URL> resolveResources(ResourceType type, Iterable<String> path, String id) throws IOException {
        if (id.length() > 0) {
            block0 : switch (type) {
                case WIKI: {
                    File current = this.base;
                    for (String segment : path) {
                        File relative = new File(current, segment);
                        if (!relative.exists()) break block0;
                        current = relative.getParentFile();
                    }
                    File resolved = new File(current, id);
                    if (resolved == null || !resolved.isFile()) break;
                    return Arrays.asList(resolved.toURI().toURL());
                }
                case XML: 
                case JAVA: 
                case DEFAULT: {
                    if (id.startsWith("/")) {
                        id = id.substring(1);
                    }
                    Enumeration<URL> urls = Thread.currentThread().getContextClassLoader().getResources(id);
                    ArrayList<URL> streams = new ArrayList<URL>();
                    while (urls.hasMoreElements()) {
                        URL url = urls.nextElement();
                        streams.add(url);
                    }
                    return streams;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
        return Collections.emptyList();
    }

    public boolean getHighlightCode() {
        return this.highlightCode;
    }

    public void setHighlightCode(boolean highlightCode) {
        this.highlightCode = highlightCode;
    }

    @Override
    public String getCharsetName() {
        return this.charsetName;
    }

    public void setCharsetName(String charsetName) {
        this.charsetName = charsetName;
    }
}

