/*
 * Decompiled with CFR 0.152.
 */
package org.wikibrain.wikidata;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.wikibrain.core.lang.Language;
import org.wikibrain.core.lang.LanguageSet;
import org.wikibrain.core.model.RawPage;
import org.wikibrain.parser.WpParseException;
import org.wikibrain.wikidata.JsonUtils;
import org.wikibrain.wikidata.WikidataEntity;
import org.wikibrain.wikidata.WikidataStatement;
import org.wikibrain.wikidata.WikidataValue;

public class WikidataParser {
    private static final Logger LOG = Logger.getLogger(WikidataParser.class.getName());
    private final LanguageSet langs;

    public WikidataParser() {
        this(LanguageSet.ALL);
    }

    public WikidataParser(LanguageSet langs) {
        this.langs = langs;
    }

    public WikidataEntity parse(RawPage rawPage) throws WpParseException {
        JsonObject obj;
        JsonParser parser = new JsonParser();
        try {
            obj = parser.parse(rawPage.getBody()).getAsJsonObject();
        }
        catch (JsonSyntaxException e) {
            System.err.println("invalid page: " + rawPage.getBody());
            throw new WpParseException((Exception)((Object)e));
        }
        if (!obj.has("entity")) {
            throw new WpParseException("Page " + obj + " missing entity field");
        }
        WikidataEntity record = this.parseEntity(obj.get("entity"));
        for (Map.Entry fields : obj.entrySet()) {
            String name = (String)fields.getKey();
            if (name.equals("label")) {
                this.parseLabels(record, (JsonElement)fields.getValue());
                continue;
            }
            if (name.equals("description")) {
                this.parseDescription(record, (JsonElement)fields.getValue());
                continue;
            }
            if (name.equals("aliases")) {
                this.parseAliases(record, (JsonElement)fields.getValue());
                continue;
            }
            if (name.equals("links") || name.equals("entity")) continue;
            if (name.equals("claims")) {
                this.parseClaims(record, (JsonElement)fields.getValue());
                continue;
            }
            if (name.equals("datatype")) {
                String value = ((JsonElement)fields.getValue()).getAsString();
                continue;
            }
            LOG.log(Level.WARNING, "unexpected field '" + name + "' when parsing " + rawPage.getTitle());
        }
        return record;
    }

    private void parseClaims(WikidataEntity record, JsonElement value) throws WpParseException {
        JsonArray array = value.getAsJsonArray();
        for (int i = 0; i < array.size(); ++i) {
            try {
                WikidataStatement statement = this.parseOneClaim(record, array.get(i));
                record.getStatements().add(statement);
                continue;
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "parse error for " + array.get(i) + ":", e);
            }
        }
    }

    private WikidataStatement parseOneClaim(WikidataEntity item, JsonElement element) throws WpParseException {
        JsonObject obj = element.getAsJsonObject();
        if (!obj.has("m")) {
            throw new WpParseException("claim " + element + " has no property m");
        }
        JsonArray jsonClaim = obj.get("m").getAsJsonArray();
        WikidataEntity prop = new WikidataEntity(WikidataEntity.Type.PROPERTY, jsonClaim.get(1).getAsInt());
        String valTypeStr = jsonClaim.get(0).getAsString();
        JsonElement jsonVal = null;
        if (valTypeStr.equals("value")) {
            valTypeStr = jsonClaim.get(2).getAsString();
            jsonVal = jsonClaim.get(3);
        }
        WikidataValue value = JsonUtils.jsonToValue(valTypeStr, jsonVal);
        WikidataStatement.Rank rank = null;
        if (obj.has("rank")) {
            int i = obj.get("rank").getAsInt();
            if (i == 0) {
                rank = WikidataStatement.Rank.DEPRECATED;
            } else if (i == 1) {
                rank = WikidataStatement.Rank.NORMAL;
            } else if (i == 2) {
                rank = WikidataStatement.Rank.PREFERRED;
            } else {
                throw new WpParseException("unknown rank: " + i + " in " + obj);
            }
        }
        String uuid = obj.has("g") ? obj.get("g").getAsString() : null;
        return new WikidataStatement(uuid, item, prop, value, rank);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private WikidataEntity parseEntity(JsonElement value) throws WpParseException {
        WikidataEntity.Type entityType = null;
        int entityId = -1;
        if (value.isJsonArray()) {
            JsonArray array = value.getAsJsonArray();
            String s = array.get(0).getAsString();
            if (s.equals("item")) {
                entityType = WikidataEntity.Type.ITEM;
            } else {
                if (!s.equals("property")) throw new WpParseException("in parseEntity expected item or property, found " + value);
                entityType = WikidataEntity.Type.PROPERTY;
            }
            entityId = array.get(1).getAsInt();
            return new WikidataEntity(entityType, entityId);
        } else {
            if (!value.isJsonPrimitive() || !value.getAsJsonPrimitive().isString()) throw new WpParseException("in parseEntity expected array, found " + value);
            String id = value.getAsString().toLowerCase();
            if (id.startsWith("q")) {
                entityType = WikidataEntity.Type.ITEM;
                entityId = Integer.valueOf(id.substring(1));
                return new WikidataEntity(entityType, entityId);
            } else {
                if (!id.startsWith("p")) throw new WpParseException("Invalid entity id: " + id);
                entityType = WikidataEntity.Type.PROPERTY;
                entityId = Integer.valueOf(id.substring(1));
            }
        }
        return new WikidataEntity(entityType, entityId);
    }

    private void parseAliases(WikidataEntity record, JsonElement value) throws WpParseException {
        if (value.isJsonArray() && value.getAsJsonArray().size() == 0) {
            return;
        }
        for (Map.Entry entry : value.getAsJsonObject().entrySet()) {
            ArrayList<String> values;
            JsonArray jsonVal;
            if (((JsonElement)entry.getValue()).isJsonArray()) {
                if (!this.validLanguage((String)entry.getKey())) continue;
                jsonVal = ((JsonElement)entry.getValue()).getAsJsonArray();
                values = new ArrayList<String>();
                for (JsonElement obj : jsonVal) {
                    values.add(obj.getAsString());
                }
                record.getAliases().put(Language.getByLangCode((String)((String)entry.getKey())), values);
                continue;
            }
            if (((JsonElement)entry.getValue()).isJsonObject()) {
                if (!this.validLanguage((String)entry.getKey())) continue;
                jsonVal = ((JsonElement)entry.getValue()).getAsJsonObject();
                values = new ArrayList();
                for (Map.Entry entry2 : jsonVal.entrySet()) {
                    values.add(((JsonElement)entry2.getValue()).getAsString());
                }
                record.getAliases().put(Language.getByLangCode((String)((String)entry.getKey())), values);
                continue;
            }
            LOG.severe("invalid alias: " + entry.getValue());
        }
    }

    private void parseDescription(WikidataEntity record, JsonElement value) {
        if (value.isJsonArray() && value.getAsJsonArray().size() == 0) {
            return;
        }
        for (Map.Entry entry : value.getAsJsonObject().entrySet()) {
            if (!this.validLanguage((String)entry.getKey())) continue;
            record.getDescriptions().put(Language.getByLangCode((String)((String)entry.getKey())), ((JsonElement)entry.getValue()).getAsString());
        }
    }

    private void parseLabels(WikidataEntity record, JsonElement value) {
        if (value.isJsonArray() && value.getAsJsonArray().size() == 0) {
            return;
        }
        for (Map.Entry entry : value.getAsJsonObject().entrySet()) {
            if (!this.validLanguage((String)entry.getKey())) continue;
            record.getLabels().put(Language.getByLangCode((String)((String)entry.getKey())), ((JsonElement)entry.getValue()).getAsString());
        }
    }

    private boolean validLanguage(String langCode) {
        return Language.hasLangCode((String)langCode) && this.langs.containsLanguage(langCode);
    }
}

