/*
 * Decompiled with CFR 0.152.
 */
package org.wikibrain.wikidata;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonPrimitive;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.time.DateUtils;
import org.wikibrain.parser.WpParseException;
import org.wikibrain.wikidata.WikidataValue;

public class JsonUtils {
    public static final WikidataValue jsonToValue(String type, JsonElement element) throws WpParseException {
        if ((type = type.toLowerCase()).equals("string")) {
            return new WikidataValue(WikidataValue.Type.STRING, (Object)element.getAsString(), element);
        }
        if (type.equals("somevalue")) {
            return new WikidataValue(WikidataValue.Type.SOMEVALUE, null, (JsonElement)JsonNull.INSTANCE);
        }
        if (type.equals("novalue")) {
            return new WikidataValue(WikidataValue.Type.NOVALUE, null, (JsonElement)JsonNull.INSTANCE);
        }
        if (type.equals("int")) {
            return new WikidataValue(WikidataValue.Type.INT, (Object)element.getAsJsonPrimitive().getAsInt(), element);
        }
        if (type.equals("time")) {
            String time = element.getAsJsonObject().get("time").getAsString();
            if (time.startsWith("+")) {
                time = time.substring(1) + "AD";
            } else if (time.startsWith("-")) {
                time = time.substring(1) + "BC";
            } else {
                throw new WpParseException("Invalid date: " + element);
            }
            try {
                return new WikidataValue(WikidataValue.Type.TIME, (Object)DateUtils.parseDate((String)time, (String[])new String[]{"yyyyyyyyyyy-MM-dd'T'HH:mm:ss'Z'G"}), element);
            }
            catch (ParseException e) {
                throw new WpParseException("Invalid date: " + element);
            }
        }
        if (type.equals("wikibase-entityid") || type.equals("item")) {
            String entityType = element.getAsJsonObject().get("entity-type").getAsString();
            if (!entityType.equals("item")) {
                throw new WpParseException("unknown entity type: " + entityType + " in " + element);
            }
            return new WikidataValue(WikidataValue.Type.ITEM, (Object)element.getAsJsonObject().get("numeric-id").getAsInt(), element);
        }
        if (Arrays.asList("globecoordinate", "other", "quantity").contains(type)) {
            return new WikidataValue(type, JsonUtils.gsonToPrimitive(element), element);
        }
        throw new WpParseException("unknown wikidata type: " + type);
    }

    public static Object gsonToPrimitive(JsonElement element) {
        if (element.isJsonPrimitive()) {
            JsonPrimitive prim = element.getAsJsonPrimitive();
            if (prim.isString()) {
                return prim.getAsString();
            }
            if (prim.isBoolean()) {
                return prim.getAsBoolean();
            }
            if (prim.isNumber()) {
                return prim.getAsNumber();
            }
            throw new IllegalArgumentException("Unknown Gson primitive: " + prim);
        }
        if (element.isJsonArray()) {
            JsonArray array = element.getAsJsonArray();
            ArrayList<Object> list = new ArrayList<Object>();
            for (int i = 0; i < array.size(); ++i) {
                list.add(JsonUtils.gsonToPrimitive(array.get(i)));
            }
            return list;
        }
        if (element.isJsonNull()) {
            return null;
        }
        if (element.isJsonObject()) {
            HashMap map = new HashMap();
            for (Map.Entry entry : element.getAsJsonObject().entrySet()) {
                map.put(entry.getKey(), JsonUtils.gsonToPrimitive((JsonElement)entry.getValue()));
            }
            return map;
        }
        throw new IllegalArgumentException("Unknown Gson value: " + element);
    }
}

