/*
 * Decompiled with CFR 0.152.
 */
package org.wikibrain.wikidata;

import java.io.File;
import java.util.Arrays;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.wikibrain.core.lang.Language;
import org.wikibrain.core.lang.LanguageInfo;
import org.wikibrain.core.lang.LanguageSet;
import org.wikibrain.core.model.RawPage;
import org.wikibrain.parser.DumpSplitter;
import org.wikibrain.parser.xml.PageXmlParser;
import org.wikibrain.wikidata.WikidataEntity;
import org.wikibrain.wikidata.WikidataParser;

public class WikidataDumpParser
implements Iterable<WikidataEntity> {
    public static final Logger LOG = Logger.getLogger(DumpSplitter.class.getName());
    private final WikidataParser wdParser;
    private final PageXmlParser xmlParser;
    private final LanguageSet languages;
    private final DumpSplitter impl;

    public WikidataDumpParser(File file) {
        this(file, LanguageSet.ALL);
    }

    public WikidataDumpParser(File file, LanguageSet languages) {
        this.languages = languages;
        this.impl = new DumpSplitter(file);
        this.xmlParser = new PageXmlParser(LanguageInfo.getByLanguage((Language)Language.EN));
        this.wdParser = new WikidataParser();
    }

    @Override
    public Iterator<WikidataEntity> iterator() {
        return new IteratorImpl();
    }

    public class IteratorImpl
    implements Iterator<WikidataEntity> {
        private final Iterator<String> iterImpl;
        private WikidataEntity buff;

        public IteratorImpl() {
            this.iterImpl = WikidataDumpParser.this.impl.iterator();
        }

        @Override
        public boolean hasNext() {
            if (this.buff == null) {
                this.fillBuff();
            }
            return this.buff != null;
        }

        private void fillBuff() {
            if (this.buff != null) {
                return;
            }
            while (this.buff == null && this.iterImpl.hasNext()) {
                try {
                    RawPage rp = WikidataDumpParser.this.xmlParser.parse(this.iterImpl.next());
                    if (rp.getModel().equals("wikibase-item") || rp.getModel().equals("wikibase-property")) {
                        this.buff = WikidataDumpParser.this.wdParser.parse(rp);
                        if (this.buff.prune(WikidataDumpParser.this.languages)) continue;
                        this.buff = null;
                        continue;
                    }
                    if (Arrays.asList("wikitext", "css", "javascript").contains(rp.getModel())) {
                        this.buff = null;
                        continue;
                    }
                    LOG.warning("unknown model: " + rp.getModel() + " in page " + rp.getTitle());
                }
                catch (Exception e) {
                    LOG.log(Level.WARNING, "parsing of " + WikidataDumpParser.this.impl.getPath() + " failed:", e);
                }
            }
        }

        @Override
        public WikidataEntity next() {
            this.fillBuff();
            WikidataEntity next = this.buff;
            this.buff = null;
            return next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

