/*
 * Decompiled with CFR 0.152.
 */
package org.wikibrain.wikidata;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.wikibrain.core.lang.Language;
import org.wikibrain.core.lang.LanguageSet;
import org.wikibrain.wikidata.WikidataStatement;

public class WikidataEntity
implements Serializable {
    private Type type;
    private int id;
    private Map<Language, String> labels = new LinkedHashMap<Language, String>();
    private Map<Language, String> descriptions = new LinkedHashMap<Language, String>();
    private Map<Language, List<String>> aliases = new LinkedHashMap<Language, List<String>>();
    private List<WikidataStatement> statements = new ArrayList<WikidataStatement>();

    public WikidataEntity(Type type, int id) {
        this.type = type;
        this.id = id;
    }

    public Type getType() {
        return this.type;
    }

    public int getId() {
        return this.id;
    }

    public String getStringId() {
        return this.type.code + "" + this.id;
    }

    public Map<Language, String> getLabels() {
        return this.labels;
    }

    public Map<Language, String> getDescriptions() {
        return this.descriptions;
    }

    public Map<Language, List<String>> getAliases() {
        return this.aliases;
    }

    public List<WikidataStatement> getStatements() {
        return this.statements;
    }

    public Map<String, List<WikidataStatement>> getStatementsInLanguage(Language language) {
        HashMap<String, List<WikidataStatement>> inLang = new HashMap<String, List<WikidataStatement>>();
        for (WikidataStatement s : this.statements) {
            String label = s.getProperty().getLabels().get(language);
            if (label == null) continue;
            if (!inLang.containsKey(label)) {
                inLang.put(label, new ArrayList());
            }
            ((List)inLang.get(label)).add(s);
        }
        return inLang;
    }

    public boolean prune(LanguageSet langs) {
        this.pruneSet(this.aliases.keySet(), langs);
        this.pruneSet(this.descriptions.keySet(), langs);
        this.pruneSet(this.labels.keySet(), langs);
        return this.aliases.size() > 0 || this.descriptions.size() > 0 || this.labels.size() > 0;
    }

    private void pruneSet(Collection<Language> set, LanguageSet keepers) {
        Iterator<Language> iter = set.iterator();
        while (iter.hasNext()) {
            Language l = iter.next();
            if (keepers.containsLanguage(l)) continue;
            iter.remove();
        }
    }

    public int hashCode() {
        return this.type.hashCode() + 37 * this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WikidataEntity that = (WikidataEntity)o;
        if (this.id != that.id) {
            return false;
        }
        return this.type == that.type;
    }

    public String toString() {
        Language en = Language.getByLangCode((String)"en");
        String name = this.labels.containsKey(en) ? this.labels.get(en) : (this.labels.isEmpty() ? "unknown" : this.labels.values().iterator().next());
        return "WikidataEntity{type=" + (Object)((Object)this.type) + ", id=" + this.id + ", name=" + name + '}';
    }

    public static enum Type {
        ITEM('Q'),
        PROPERTY('P');

        public char code;

        private Type(char code) {
            this.code = code;
        }

        public static Type getByCode(char code) {
            code = Character.toUpperCase(code);
            for (Type type : Type.values()) {
                if (type.code != code) continue;
                return type;
            }
            throw new IllegalArgumentException("Unknown type code: " + code);
        }
    }
}

