/*
 * Decompiled with CFR 0.152.
 */
package org.wikibrain.wikidata;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.LineIterator;
import org.wikibrain.core.lang.LanguageSet;
import org.wikibrain.parser.DumpSplitter;
import org.wikibrain.utils.WpIOUtils;
import org.wikibrain.wikidata.WikidataEntity;
import org.wikibrain.wikidata.WikidataParser;

public class WikidataDumpParser
implements Iterable<WikidataEntity> {
    public static final Logger LOG = Logger.getLogger(DumpSplitter.class.getName());
    private final WikidataParser wdParser;
    private final LanguageSet languages;
    private final File file;

    public WikidataDumpParser(File file) {
        this(file, LanguageSet.ALL);
    }

    public WikidataDumpParser(File file, LanguageSet languages) {
        this.file = file;
        this.languages = languages;
        this.wdParser = new WikidataParser();
    }

    @Override
    public Iterator<WikidataEntity> iterator() {
        return new IteratorImpl();
    }

    public class IteratorImpl
    implements Iterator<WikidataEntity> {
        private final Iterator<String> iterImpl;
        private WikidataEntity buff;

        public IteratorImpl() {
            try {
                this.iterImpl = new LineIterator((Reader)WpIOUtils.openBufferedReader((File)WikidataDumpParser.this.file));
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        }

        @Override
        public boolean hasNext() {
            if (this.buff == null) {
                this.fillBuff();
            }
            return this.buff != null;
        }

        private void fillBuff() {
            if (this.buff != null) {
                return;
            }
            while (this.buff == null && this.iterImpl.hasNext()) {
                String line = this.iterImpl.next();
                if (line.trim().equals("[") || line.trim().equals("]")) continue;
                try {
                    if (line.endsWith(",")) {
                        line = line.substring(0, line.length() - 1);
                    }
                    this.buff = WikidataDumpParser.this.wdParser.parse(line);
                }
                catch (Exception e) {
                    LOG.log(Level.WARNING, "parsing of " + WikidataDumpParser.this.file + " failed for line '" + line + "':", e);
                }
            }
        }

        @Override
        public WikidataEntity next() {
            this.fillBuff();
            WikidataEntity next = this.buff;
            this.buff = null;
            return next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

