/*
 * Decompiled with CFR 0.152.
 */
package org.wikibrain.wikidata;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.wikibrain.core.model.NameSpace;
import org.wikibrain.core.model.RawPage;
import org.wikibrain.core.model.Title;
import org.wikidata.wdtk.dumpfiles.MwRevision;

public class RawPageWrapper
implements MwRevision {
    private final RawPage raw;

    public RawPageWrapper(RawPage raw) {
        this.raw = raw;
    }

    public String getPrefixedTitle() {
        Title t = this.raw.getTitle();
        if (this.raw.getNamespace() == NameSpace.WIKIPEDIA) {
            return t.getTitleStringWithoutNamespace();
        }
        return t.getNamespaceString() + ":" + t.getTitleStringWithoutNamespace();
    }

    public String getTitle() {
        return this.raw.getTitle().getTitleStringWithoutNamespace();
    }

    public int getNamespace() {
        return this.raw.getNamespace().getValue();
    }

    public int getPageId() {
        return this.raw.getLocalId();
    }

    public long getRevisionId() {
        return this.raw.getRevisionId();
    }

    public String getTimeStamp() {
        return RawPageWrapper.getISO8601StringForDate(this.raw.getLastEdit());
    }

    public String getText() {
        return this.raw.getBody();
    }

    public String getModel() {
        return this.raw.getModel();
    }

    public String getFormat() {
        return this.raw.getFormat();
    }

    public String getComment() {
        return "Fake";
    }

    public String getContributor() {
        return "fake";
    }

    public int getContributorId() {
        return -1;
    }

    public boolean hasRegisteredContributor() {
        return false;
    }

    private static String getISO8601StringForDate(Date date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.US);
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return dateFormat.format(date);
    }
}

