/*
 * Decompiled with CFR 0.152.
 */
package org.wikibrain.wikidata;

import java.io.IOException;
import org.wikidata.wdtk.dumpfiles.DumpContentType;
import org.wikidata.wdtk.dumpfiles.DumpProcessingController;
import org.wikidata.wdtk.dumpfiles.MwDumpFile;
import org.wikidata.wdtk.dumpfiles.wmf.WmfDumpFile;
import org.wikidata.wdtk.dumpfiles.wmf.WmfDumpFileManager;

public class WikidataDumpHelper {
    private DumpProcessingController controller = new DumpProcessingController("wikidatawiki");
    private static final String PROJECT = "wikidatawiki";
    private static final DumpContentType JSON_TYPE = DumpContentType.JSON;

    public String getMostRecentDate() throws IOException {
        WmfDumpFileManager manager = this.controller.getWmfDumpFileManager();
        MwDumpFile file = manager.findMostRecentDump(JSON_TYPE);
        return file.getDateStamp();
    }

    public String getMostRecentFile() throws IOException {
        WmfDumpFileManager manager = this.controller.getWmfDumpFileManager();
        MwDumpFile file = manager.findMostRecentDump(DumpContentType.JSON);
        String tstamp = file.getDateStamp();
        return WmfDumpFile.getDumpFileName((DumpContentType)JSON_TYPE, (String)PROJECT, (String)tstamp);
    }

    public String getMostRecentUrl() throws IOException {
        String baseUrl = WmfDumpFile.getDumpFileWebDirectory((DumpContentType)JSON_TYPE, (String)PROJECT);
        return baseUrl + this.getMostRecentFile();
    }

    public static void main(String[] args) throws IOException {
        WikidataDumpHelper helper = new WikidataDumpHelper();
        System.out.println(helper.getMostRecentDate());
        System.out.println(helper.getMostRecentUrl());
    }
}

