/*
 * Decompiled with CFR 0.152.
 */
package org.wikibrain.wikidata;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.wikibrain.core.lang.Language;
import org.wikibrain.wikidata.WikidataEntity;
import org.wikibrain.wikidata.WikidataStatement;
import org.wikibrain.wikidata.WikidataValue;

public class WikidataFilter {
    private Collection<Language> langs;
    private Collection<WikidataEntity.Type> entityTypes;
    private Collection<Integer> entityIds;
    private Collection<Integer> propertyIds;
    private Collection<WikidataStatement.Rank> ranks;
    private Collection<WikidataValue> values;

    public Collection<Language> getLangs() {
        return this.langs;
    }

    public Collection<Short> getLangIds() {
        if (this.langs == null) {
            return null;
        }
        HashSet<Short> ids = new HashSet<Short>();
        for (Language lang : this.langs) {
            ids.add(lang.getId());
        }
        return ids;
    }

    public Collection<WikidataEntity.Type> getEntityTypes() {
        return this.entityTypes;
    }

    public Collection<String> getEntityTypeCodes() {
        if (this.entityTypes == null) {
            return null;
        }
        HashSet<String> typeCodes = new HashSet<String>();
        for (WikidataEntity.Type type : this.entityTypes) {
            typeCodes.add(Character.toString(type.code));
        }
        return typeCodes;
    }

    public Collection<WikidataValue> getValues() {
        return this.values;
    }

    public Collection<Integer> getEntityIds() {
        return this.entityIds;
    }

    public Collection<Integer> getPropertyIds() {
        return this.propertyIds;
    }

    public Collection<WikidataStatement.Rank> getRanks() {
        return this.ranks;
    }

    public Collection<Short> getRankOrdinals() {
        if (this.ranks == null) {
            return null;
        }
        HashSet<Short> ordinals = new HashSet<Short>();
        for (WikidataStatement.Rank rank : this.ranks) {
            ordinals.add((short)rank.ordinal());
        }
        return ordinals;
    }

    public static class Builder {
        private WikidataFilter filter = new WikidataFilter();

        public Builder withLanguage(Language language) {
            this.filter.langs = Arrays.asList(language);
            return this;
        }

        public Builder withLanguages(Collection<Language> languages) {
            this.filter.langs = languages;
            return this;
        }

        public Builder withEntityType(WikidataEntity.Type type) {
            this.filter.entityTypes = Arrays.asList(type);
            return this;
        }

        public Builder withEntityType(Collection<WikidataEntity.Type> types) {
            this.filter.entityTypes = types;
            return this;
        }

        public Builder withEntityId(int id) {
            this.filter.entityIds = Arrays.asList(id);
            return this;
        }

        public Builder withEntityIds(Collection<Integer> ids) {
            this.filter.entityIds = ids;
            return this;
        }

        public Builder withPropertyId(int id) {
            this.filter.propertyIds = Arrays.asList(id);
            return this;
        }

        public Builder withPropertyIds(Collection<Integer> ids) {
            this.filter.propertyIds = ids;
            return this;
        }

        public Builder withRank(WikidataStatement.Rank rank) {
            this.filter.ranks = Arrays.asList(rank);
            return this;
        }

        public Builder withRanks(Collection<WikidataStatement.Rank> ranks) {
            this.filter.ranks = ranks;
            return this;
        }

        public Builder withValue(WikidataValue value) {
            this.filter.values = Arrays.asList(value);
            return this;
        }

        public Builder withValues(Collection<WikidataValue> values) {
            this.filter.values = values;
            return this;
        }

        public WikidataFilter build() {
            return this.filter;
        }
    }
}

