/*
 * Decompiled with CFR 0.152.
 */
package org.wikibrain.wikidata;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wikibrain.core.lang.Language;
import org.wikibrain.core.lang.LanguageSet;
import org.wikibrain.parser.WpParseException;
import org.wikibrain.wikidata.WikidataEntity;
import org.wikibrain.wikidata.WikidataStatement;
import org.wikibrain.wikidata.WikidataValue;
import org.wikidata.wdtk.datamodel.helpers.DatamodelConverter;
import org.wikidata.wdtk.datamodel.interfaces.DataObjectFactory;
import org.wikidata.wdtk.datamodel.interfaces.DatatypeIdValue;
import org.wikidata.wdtk.datamodel.interfaces.EntityIdValue;
import org.wikidata.wdtk.datamodel.interfaces.GlobeCoordinatesValue;
import org.wikidata.wdtk.datamodel.interfaces.MonolingualTextValue;
import org.wikidata.wdtk.datamodel.interfaces.NoValueSnak;
import org.wikidata.wdtk.datamodel.interfaces.QuantityValue;
import org.wikidata.wdtk.datamodel.interfaces.SnakVisitor;
import org.wikidata.wdtk.datamodel.interfaces.SomeValueSnak;
import org.wikidata.wdtk.datamodel.interfaces.StatementRank;
import org.wikidata.wdtk.datamodel.interfaces.StringValue;
import org.wikidata.wdtk.datamodel.interfaces.TimeValue;
import org.wikidata.wdtk.datamodel.interfaces.Value;
import org.wikidata.wdtk.datamodel.interfaces.ValueSnak;
import org.wikidata.wdtk.datamodel.interfaces.ValueVisitor;
import org.wikidata.wdtk.datamodel.json.jackson.JacksonItemDocument;
import org.wikidata.wdtk.datamodel.json.jackson.JacksonObjectFactory;
import org.wikidata.wdtk.datamodel.json.jackson.JacksonStatement;
import org.wikidata.wdtk.datamodel.json.jackson.JacksonTermedStatementDocument;
import org.wikidata.wdtk.datamodel.json.jackson.JacksonValueSnak;
import org.wikidata.wdtk.datamodel.json.jackson.datavalues.JacksonValue;

public class WikidataParser {
    private static final Logger LOG = LoggerFactory.getLogger(WikidataParser.class);
    private final LanguageSet langs;
    final ObjectMapper mapper = new ObjectMapper();
    private final DatamodelConverter datamodelConverter = new DatamodelConverter((DataObjectFactory)new JacksonObjectFactory());
    private static BufferedWriter writer;

    public WikidataParser() {
        this(LanguageSet.ALL);
    }

    public WikidataParser(LanguageSet langs) {
        this.langs = langs;
    }

    public WikidataEntity parse(String json) throws WpParseException {
        Language lang;
        JacksonTermedStatementDocument mwDoc;
        try {
            mwDoc = (JacksonTermedStatementDocument)this.mapper.readValue(json, JacksonTermedStatementDocument.class);
        }
        catch (IOException e) {
            LOG.info("Error parsing: " + json);
            throw new WpParseException((Exception)e);
        }
        WikidataEntity record = new WikidataEntity(mwDoc.getEntityId().getId());
        for (List vlist : mwDoc.getAliases().values()) {
            if (vlist.isEmpty() || !this.validLanguage(((MonolingualTextValue)vlist.get(0)).getLanguageCode())) continue;
            lang = Language.getByLangCodeLenient((String)((MonolingualTextValue)vlist.get(0)).getLanguageCode());
            record.getAliases().put(lang, new ArrayList());
            for (MonolingualTextValue v : vlist) {
                record.getAliases().get(lang).add(v.getText());
            }
        }
        for (MonolingualTextValue v : mwDoc.getDescriptions().values()) {
            if (!this.validLanguage(v.getLanguageCode())) continue;
            lang = Language.getByLangCodeLenient((String)v.getLanguageCode());
            record.getDescriptions().put(lang, v.getText());
        }
        for (MonolingualTextValue v : mwDoc.getLabels().values()) {
            if (!this.validLanguage(v.getLanguageCode())) continue;
            lang = Language.getByLangCodeLenient((String)v.getLanguageCode());
            record.getLabels().put(lang, v.getText());
        }
        if (mwDoc instanceof JacksonItemDocument) {
            for (List statements : ((JacksonItemDocument)mwDoc).getJsonClaims().values()) {
                for (JacksonStatement s : statements) {
                    record.getStatements().add(this.parseOneClaim(record, s));
                }
            }
        }
        return record;
    }

    private WikidataStatement parseOneClaim(WikidataEntity item, JacksonStatement js) throws WpParseException {
        WikidataStatement.Rank rank;
        WikidataValue value;
        String propId = js.getMainsnak().getProperty();
        WikidataEntity prop = new WikidataEntity(WikidataEntity.Type.PROPERTY, Integer.valueOf(propId.substring(1)));
        String valTypeStr = (String)js.getMainsnak().accept((SnakVisitor)new SnakVisitor<String>(){

            public String visit(ValueSnak snak) {
                return "value";
            }

            public String visit(SomeValueSnak snak) {
                return "somevalue";
            }

            public String visit(NoValueSnak snak) {
                return "novalue";
            }
        });
        JsonElement jsonVal = null;
        if (valTypeStr.equals("value")) {
            JacksonValueSnak snak = (JacksonValueSnak)js.getMainsnak();
            valTypeStr = ((JacksonValue)snak.getValue()).getType();
            value = this.snakToValue(valTypeStr, snak.getValue());
        } else {
            value = this.jsonToValue(valTypeStr, jsonVal);
        }
        if (js.getRank() == null) {
            rank = null;
        } else if (js.getRank() == StatementRank.PREFERRED) {
            rank = WikidataStatement.Rank.PREFERRED;
        } else if (js.getRank() == StatementRank.NORMAL) {
            rank = WikidataStatement.Rank.NORMAL;
        } else if (js.getRank() == StatementRank.DEPRECATED) {
            rank = WikidataStatement.Rank.DEPRECATED;
        } else {
            throw new WpParseException("unknown rank: " + js.getRank() + " in " + js);
        }
        String uuid = js.getStatementId();
        return new WikidataStatement(uuid, item, prop, value, rank);
    }

    public WikidataValue snakToValue(final String type, Value snak) {
        String jsonStr = null;
        try {
            jsonStr = this.mapper.writeValueAsString((Object)snak);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Unknown snak: " + snak);
        }
        JsonElement element = new JsonParser().parse(jsonStr);
        final JsonElement jsonValue = element.isJsonObject() && element.getAsJsonObject().has("value") ? element.getAsJsonObject().get("value") : null;
        WikidataValue val = (WikidataValue)snak.accept((ValueVisitor)new ValueVisitor<WikidataValue>(){

            public WikidataValue visit(EntityIdValue value) {
                if (value.getEntityType().equals("http://www.wikidata.org/ontology#Item")) {
                    return WikidataValue.forItem(Integer.valueOf(value.getId().substring(1)));
                }
                if (value.getEntityType().equals("http://www.wikidata.org/ontology#Property")) {
                    throw new IllegalArgumentException("Did not expect entity property");
                }
                throw new IllegalArgumentException("Unknown entity type: " + value.getEntityType());
            }

            public WikidataValue visit(GlobeCoordinatesValue value) {
                return new WikidataValue(type, WikidataParser.gsonToPrimitive(jsonValue), jsonValue);
            }

            public WikidataValue visit(QuantityValue value) {
                return new WikidataValue(type, WikidataParser.gsonToPrimitive(jsonValue), jsonValue);
            }

            public WikidataValue visit(StringValue value) {
                return WikidataValue.forString(value.getString());
            }

            public WikidataValue visit(TimeValue value) {
                GregorianCalendar c = new GregorianCalendar((int)value.getYear(), value.getMonth() - 1, value.getDay(), value.getHour(), value.getMinute(), value.getSecond());
                return new WikidataValue(WikidataValue.Type.TIME, (Object)c.getTime(), jsonValue);
            }

            public WikidataValue visit(MonolingualTextValue value) {
                return WikidataValue.forString(value.getText());
            }

            public WikidataValue visit(DatatypeIdValue value) {
                throw new IllegalArgumentException();
            }
        });
        return val;
    }

    public WikidataValue jsonToValue(String type, JsonElement element) throws WpParseException {
        if (type.equals("somevalue")) {
            return new WikidataValue(WikidataValue.Type.SOMEVALUE, null, (JsonElement)JsonNull.INSTANCE);
        }
        if (type.equals("novalue")) {
            return new WikidataValue(WikidataValue.Type.NOVALUE, null, (JsonElement)JsonNull.INSTANCE);
        }
        if (type.equals("item") || type.equals("property")) {
            type = "wikibase-entityid";
        }
        String fullJson = "{ \"type\" : \"" + type + "\", \"value\" : " + element.toString() + " }";
        try {
            Value snak = (Value)this.mapper.readValue(fullJson, JacksonValue.class);
            return this.snakToValue(type, snak);
        }
        catch (IOException e) {
            throw new WpParseException((Exception)e);
        }
    }

    public static Object gsonToPrimitive(JsonElement element) {
        if (element.isJsonPrimitive()) {
            JsonPrimitive prim = element.getAsJsonPrimitive();
            if (prim.isString()) {
                return prim.getAsString();
            }
            if (prim.isBoolean()) {
                return prim.getAsBoolean();
            }
            if (prim.isNumber()) {
                return prim.getAsNumber();
            }
            throw new IllegalArgumentException("Unknown Gson primitive: " + prim);
        }
        if (element.isJsonArray()) {
            JsonArray array = element.getAsJsonArray();
            ArrayList<Object> list = new ArrayList<Object>();
            for (int i = 0; i < array.size(); ++i) {
                list.add(WikidataParser.gsonToPrimitive(array.get(i)));
            }
            return list;
        }
        if (element.isJsonNull()) {
            return null;
        }
        if (element.isJsonObject()) {
            HashMap map = new HashMap();
            for (Map.Entry entry : element.getAsJsonObject().entrySet()) {
                map.put(entry.getKey(), WikidataParser.gsonToPrimitive((JsonElement)entry.getValue()));
            }
            return map;
        }
        throw new IllegalArgumentException("Unknown Gson value: " + element);
    }

    private boolean validLanguage(String langCode) {
        return Language.hasLangCode((String)langCode) && this.langs.containsLanguage(langCode);
    }
}

