/*
 * Decompiled with CFR 0.152.
 */
package org.wikibrain.wikidata;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.typesafe.config.Config;
import gnu.trove.set.hash.TIntHashSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections.IteratorUtils;
import org.jooq.Condition;
import org.jooq.Cursor;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.Record1;
import org.jooq.Record2;
import org.jooq.Result;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.TableLike;
import org.wikibrain.conf.Configuration;
import org.wikibrain.conf.ConfigurationException;
import org.wikibrain.conf.Configurator;
import org.wikibrain.core.dao.DaoException;
import org.wikibrain.core.dao.DaoFilter;
import org.wikibrain.core.dao.LocalPageDao;
import org.wikibrain.core.dao.UniversalPageDao;
import org.wikibrain.core.dao.sql.AbstractSqlDao;
import org.wikibrain.core.dao.sql.FastLoader;
import org.wikibrain.core.dao.sql.SimpleSqlDaoIterable;
import org.wikibrain.core.dao.sql.WpDataSource;
import org.wikibrain.core.jooq.Tables;
import org.wikibrain.core.jooq.tables.WikidataEntityAliases;
import org.wikibrain.core.jooq.tables.WikidataEntityDescriptions;
import org.wikibrain.core.jooq.tables.WikidataEntityLabels;
import org.wikibrain.core.lang.Language;
import org.wikibrain.core.lang.LocalId;
import org.wikibrain.core.model.LocalPage;
import org.wikibrain.core.model.UniversalPage;
import org.wikibrain.parser.WpParseException;
import org.wikibrain.wikidata.LocalWikidataStatement;
import org.wikibrain.wikidata.WikidataDao;
import org.wikibrain.wikidata.WikidataEntity;
import org.wikibrain.wikidata.WikidataFilter;
import org.wikibrain.wikidata.WikidataParser;
import org.wikibrain.wikidata.WikidataStatement;
import org.wikibrain.wikidata.WikidataValue;

public class WikidataSqlDao
extends AbstractSqlDao<WikidataStatement>
implements WikidataDao {
    private static Language FALLBACK_LANGUAGE = Language.getByLangCode((String)"en");
    private static TableField[] FIELDS = new TableField[]{org.wikibrain.core.jooq.tables.WikidataStatement.WIKIDATA_STATEMENT.ID, org.wikibrain.core.jooq.tables.WikidataStatement.WIKIDATA_STATEMENT.ENTITY_TYPE, org.wikibrain.core.jooq.tables.WikidataStatement.WIKIDATA_STATEMENT.ENTITY_ID, org.wikibrain.core.jooq.tables.WikidataStatement.WIKIDATA_STATEMENT.PROP_ID, org.wikibrain.core.jooq.tables.WikidataStatement.WIKIDATA_STATEMENT.VAL_TYPE, org.wikibrain.core.jooq.tables.WikidataStatement.WIKIDATA_STATEMENT.VAL_STR, org.wikibrain.core.jooq.tables.WikidataStatement.WIKIDATA_STATEMENT.RANK};
    private final LocalPageDao lpDao;
    private final UniversalPageDao upDao;
    private Gson gson = new Gson();
    private FastLoader labelLoader = null;
    private FastLoader descLoader = null;
    private FastLoader aliasLoader = null;
    private Map<Integer, WikidataEntity> properties;
    private WikidataParser parser = new WikidataParser();

    public WikidataSqlDao(WpDataSource dataSource, LocalPageDao lpDao, UniversalPageDao upDao) throws DaoException {
        super(dataSource, FIELDS, "/db/wikidata");
        this.lpDao = lpDao;
        this.upDao = upDao;
    }

    @Override
    public WikidataEntity getProperty(Language language, String name) throws DaoException {
        name = name.toLowerCase();
        for (WikidataEntity entity : this.getProperties().values()) {
            String ename = entity.getLabels().get(language);
            if (ename == null || !ename.toLowerCase().equals(name)) continue;
            return entity;
        }
        return null;
    }

    @Override
    public WikidataEntity getProperty(int id) throws DaoException {
        Map<Integer, WikidataEntity> properties = this.getProperties();
        if (properties == null || properties.size() == 0) {
            return this.getEntityWithoutCache(WikidataEntity.Type.PROPERTY, id);
        }
        return properties.get(id);
    }

    @Override
    public WikidataEntity getItem(int id) throws DaoException {
        return this.getEntityWithoutCache(WikidataEntity.Type.ITEM, id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Map<Integer, WikidataEntity> getProperties() throws DaoException {
        if (this.properties != null) {
            return this.properties;
        }
        if (this.cache != null) {
            this.properties = (Map)this.cache.get("wikidata-properties", new Class[]{WikidataEntity.class});
        }
        if (this.properties == null || this.properties.size() == 0) {
            this.properties = new ConcurrentHashMap<Integer, WikidataEntity>();
            LOG.info("creating wikidata properties cache. This only happens once...");
            DSLContext context = this.getJooq();
            try {
                Result result = context.select((SelectField)Tables.WIKIDATA_ENTITY_LABELS.ENTITY_ID).from((TableLike)Tables.WIKIDATA_ENTITY_LABELS).where(new Condition[]{Tables.WIKIDATA_ENTITY_LABELS.ENTITY_TYPE.eq((Object)("" + WikidataEntity.Type.PROPERTY.code))}).fetch();
                TIntHashSet propIds = new TIntHashSet();
                for (Record1 record : result) {
                    propIds.add(((Integer)record.value1()).intValue());
                }
                for (Object id : (Object)propIds.toArray()) {
                    this.properties.put((int)id, this.getEntityWithoutCache(WikidataEntity.Type.PROPERTY, (int)id));
                }
            }
            finally {
                this.freeJooq(context);
            }
            if (this.cache != null) {
                this.cache.put("wikidata-properties", this.properties);
            }
        }
        LOG.info("loaded properties with size " + (this.properties == null ? 0 : this.properties.size()));
        return this.properties;
    }

    @Override
    public Integer getItemId(LocalPage page) throws DaoException {
        return this.upDao.getUnivPageId(page);
    }

    @Override
    public Integer getItemId(LocalId localId) throws DaoException {
        return this.upDao.getUnivPageId(localId.getLanguage(), localId.getId());
    }

    @Override
    public UniversalPage getUniversalPage(int itemId) throws DaoException {
        UniversalPage uPage = this.upDao.getById(itemId);
        return uPage;
    }

    @Override
    public List<WikidataStatement> getStatements(LocalPage page) throws DaoException {
        int conceptId = this.upDao.getUnivPageId(page);
        if (conceptId < 0) {
            return new ArrayList<WikidataStatement>();
        }
        WikidataFilter filter = new WikidataFilter.Builder().withEntityType(WikidataEntity.Type.ITEM).withEntityId(conceptId).build();
        return IteratorUtils.toList(this.get(filter).iterator());
    }

    public Collection<WikidataEntity> getPropertyByName(Language language, String name) throws DaoException {
        ArrayList<WikidataEntity> matches = new ArrayList<WikidataEntity>();
        Map<Integer, WikidataEntity> props = this.getProperties();
        for (WikidataEntity e : props.values()) {
            if (e.getAliases().containsKey(language) && e.getAliases().get(language).contains(name)) {
                matches.add(e);
                continue;
            }
            if (!e.getLabels().containsKey(language) || !e.getLabels().get(language).contains(name)) continue;
            matches.add(e);
        }
        return matches;
    }

    public Collection<WikidataEntity> getPropertyByName(String name) throws DaoException {
        HashSet<WikidataEntity> matches = new HashSet<WikidataEntity>();
        Map<Integer, WikidataEntity> props = this.getProperties();
        for (WikidataEntity e : props.values()) {
            if (e.getLabels().values().contains(name)) {
                matches.add(e);
                continue;
            }
            if (!e.getAliases().values().contains(name)) continue;
            matches.add(e);
        }
        return matches;
    }

    @Override
    public Map<String, List<LocalWikidataStatement>> getLocalStatements(LocalPage page) throws DaoException {
        int conceptId = this.getItemId(page);
        if (conceptId < 0) {
            return new HashMap<String, List<LocalWikidataStatement>>();
        }
        return this.getLocalStatements(this.getRealLang(page.getLanguage()), WikidataEntity.Type.ITEM, conceptId);
    }

    private Language getRealLang(Language lang) {
        if (lang.getLangCode().equals("simple")) {
            return Language.getByLangCode((String)"en");
        }
        return lang;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WikidataEntity getEntityWithoutCache(WikidataEntity.Type type, int id) throws DaoException {
        WikidataEntity entity = new WikidataEntity(type, id);
        DSLContext jooq = this.getJooq();
        try {
            Result result = jooq.select((SelectField)Tables.WIKIDATA_ENTITY_LABELS.LANG_ID, (SelectField)Tables.WIKIDATA_ENTITY_LABELS.LABEL).from((TableLike)Tables.WIKIDATA_ENTITY_LABELS).where(new Condition[]{Tables.WIKIDATA_ENTITY_LABELS.ENTITY_TYPE.eq((Object)(type.code + ""))}).and(Tables.WIKIDATA_ENTITY_LABELS.ENTITY_ID.eq((Object)id)).fetch();
            for (Object record : result) {
                entity.getLabels().put(Language.getById((int)((Short)record.value1()).shortValue()), (String)record.value2());
            }
            Result result2 = jooq.select((SelectField)Tables.WIKIDATA_ENTITY_DESCRIPTIONS.LANG_ID, (SelectField)Tables.WIKIDATA_ENTITY_DESCRIPTIONS.DESCRIPTION).from((TableLike)Tables.WIKIDATA_ENTITY_DESCRIPTIONS).where(new Condition[]{Tables.WIKIDATA_ENTITY_DESCRIPTIONS.ENTITY_TYPE.eq((Object)(type.code + ""))}).and(Tables.WIKIDATA_ENTITY_DESCRIPTIONS.ENTITY_ID.eq((Object)id)).fetch();
            for (Record2 record : result2) {
                entity.getDescriptions().put(Language.getById((int)((Short)record.value1()).shortValue()), (String)record.value2());
            }
            Result result3 = jooq.select((SelectField)Tables.WIKIDATA_ENTITY_ALIASES.LANG_ID, (SelectField)Tables.WIKIDATA_ENTITY_ALIASES.ALIAS).from((TableLike)Tables.WIKIDATA_ENTITY_ALIASES).where(new Condition[]{Tables.WIKIDATA_ENTITY_ALIASES.ENTITY_TYPE.eq((Object)(type.code + ""))}).and(Tables.WIKIDATA_ENTITY_ALIASES.ENTITY_ID.eq((Object)id)).fetch();
            Map<Language, List<String>> aliases = entity.getAliases();
            for (Record2 record : result3) {
                Language lang = Language.getById((int)((Short)record.value1()).shortValue());
                if (!aliases.containsKey(lang)) {
                    aliases.put(lang, new ArrayList());
                }
                aliases.get(lang).add((String)record.value2());
            }
            WikidataFilter filter = new WikidataFilter.Builder().withEntityType(type).withEntityId(id).build();
            for (WikidataStatement st : this.get(filter)) {
                if (st == null) continue;
                entity.getStatements().add(st);
            }
            WikidataEntity wikidataEntity = entity;
            return wikidataEntity;
        }
        finally {
            this.freeJooq(jooq);
        }
    }

    public void beginLoad() throws DaoException {
        super.beginLoad();
        if (this.labelLoader == null) {
            this.labelLoader = new FastLoader(this.wpDs, new TableField[]{WikidataEntityLabels.WIKIDATA_ENTITY_LABELS.ENTITY_TYPE, WikidataEntityLabels.WIKIDATA_ENTITY_LABELS.ENTITY_ID, WikidataEntityLabels.WIKIDATA_ENTITY_LABELS.LANG_ID, WikidataEntityLabels.WIKIDATA_ENTITY_LABELS.LABEL});
        }
        if (this.descLoader == null) {
            this.descLoader = new FastLoader(this.wpDs, new TableField[]{WikidataEntityDescriptions.WIKIDATA_ENTITY_DESCRIPTIONS.ENTITY_TYPE, WikidataEntityDescriptions.WIKIDATA_ENTITY_DESCRIPTIONS.ENTITY_ID, WikidataEntityDescriptions.WIKIDATA_ENTITY_DESCRIPTIONS.LANG_ID, WikidataEntityDescriptions.WIKIDATA_ENTITY_DESCRIPTIONS.DESCRIPTION});
        }
        if (this.aliasLoader == null) {
            this.aliasLoader = new FastLoader(this.wpDs, new TableField[]{WikidataEntityAliases.WIKIDATA_ENTITY_ALIASES.ENTITY_TYPE, WikidataEntityAliases.WIKIDATA_ENTITY_ALIASES.ENTITY_ID, WikidataEntityAliases.WIKIDATA_ENTITY_ALIASES.LANG_ID, WikidataEntityAliases.WIKIDATA_ENTITY_ALIASES.ALIAS});
        }
        this.properties = new HashMap<Integer, WikidataEntity>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(WikidataEntity entity) throws DaoException {
        for (Map.Entry<Language, String> entry : entity.getLabels().entrySet()) {
            this.labelLoader.load(new Object[]{Character.valueOf(entity.getType().code), entity.getId(), entry.getKey().getId(), entry.getValue()});
        }
        for (Map.Entry<Language, String> entry : entity.getDescriptions().entrySet()) {
            this.descLoader.load(new Object[]{Character.valueOf(entity.getType().code), entity.getId(), entry.getKey().getId(), entry.getValue()});
        }
        for (Map.Entry<Language, Object> entry : entity.getAliases().entrySet()) {
            for (String alias : (List)entry.getValue()) {
                this.aliasLoader.load(new Object[]{Character.valueOf(entity.getType().code), entity.getId(), entry.getKey().getId(), alias});
            }
        }
        for (WikidataStatement wikidataStatement : entity.getStatements()) {
            this.save(wikidataStatement);
        }
        if (entity.getType() == WikidataEntity.Type.PROPERTY) {
            Map<Integer, WikidataEntity> map = this.properties;
            synchronized (map) {
                this.properties.put(entity.getId(), entity);
            }
        }
    }

    public void save(WikidataStatement item) throws DaoException {
        this.insert(new Object[]{item.getId(), Character.valueOf(item.getItem().getType().code), item.getItem().getId(), item.getProperty().getId(), item.getValue().getTypeName().toLowerCase(), this.encodeValue(item.getValue()), item.getRank().ordinal()});
    }

    private String encodeValue(WikidataValue value) {
        return this.gson.toJson(value.getJsonValue());
    }

    public void endLoad() throws DaoException {
        if (this.labelLoader != null) {
            this.labelLoader.endLoad();
        }
        if (this.descLoader != null) {
            this.descLoader.endLoad();
        }
        if (this.aliasLoader != null) {
            this.aliasLoader.endLoad();
        }
        this.labelLoader = null;
        this.descLoader = null;
        this.aliasLoader = null;
        super.endLoad();
        if (this.cache != null) {
            this.cache.put("wikidata-properties", this.properties);
        }
        this.wpDs.optimize((Table)WikidataEntityLabels.WIKIDATA_ENTITY_LABELS);
        this.wpDs.optimize((Table)WikidataEntityAliases.WIKIDATA_ENTITY_ALIASES);
        this.wpDs.optimize((Table)WikidataEntityDescriptions.WIKIDATA_ENTITY_DESCRIPTIONS);
        this.wpDs.optimize((Table)org.wikibrain.core.jooq.tables.WikidataStatement.WIKIDATA_STATEMENT);
    }

    @Override
    public Map<String, List<LocalWikidataStatement>> getLocalStatements(Language lang, WikidataEntity.Type type, int id) throws DaoException {
        lang = this.getRealLang(lang);
        WikidataFilter filter = new WikidataFilter.Builder().withEntityType(type).withEntityId(id).build();
        HashMap<String, List<LocalWikidataStatement>> local = new HashMap<String, List<LocalWikidataStatement>>();
        for (WikidataStatement st : this.get(filter)) {
            LocalWikidataStatement lws = this.getLocalStatement(lang, st);
            if (!local.containsKey(lws.getProperty())) {
                local.put(lws.getProperty(), new ArrayList());
            }
            ((List)local.get(lws.getProperty())).add(lws);
        }
        return local;
    }

    @Override
    public LocalWikidataStatement getLocalStatement(Language language, WikidataStatement statement) throws DaoException {
        language = this.getRealLang(language);
        String item = this.getLabel(language, statement.getItem().getType(), statement.getItem().getId());
        String prop = this.getLabel(language, statement.getProperty().getType(), statement.getProperty().getId());
        String value = null;
        WikidataValue wdv = statement.getValue();
        value = wdv.getType() == WikidataValue.Type.ITEM ? this.getLabel(language, WikidataEntity.Type.ITEM, wdv.getItemValue()) : (wdv.getValue() == null ? "unknown" : wdv.getValue().toString());
        String full = item + " " + prop + " " + value;
        return new LocalWikidataStatement(language, statement, full, item, prop, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getLabel(Language language, WikidataEntity.Type type, int id) throws DaoException {
        if (type == WikidataEntity.Type.PROPERTY) {
            WikidataEntity prop = this.getProperty(id);
            if (prop.getLabels().isEmpty()) {
                LOG.warn("no labels for property " + id);
                return "unknown";
            }
            if (prop.getLabels().containsKey(language)) {
                return prop.getLabels().get(language);
            }
            if (prop.getLabels().containsKey(FALLBACK_LANGUAGE)) {
                return prop.getLabels().get(FALLBACK_LANGUAGE);
            }
            return prop.getLabels().values().iterator().next();
        }
        if (type == WikidataEntity.Type.ITEM) {
            DSLContext jooq = this.getJooq();
            try {
                String string;
                for (Language l : Arrays.asList(language, FALLBACK_LANGUAGE)) {
                    Result result = jooq.select((SelectField)Tables.WIKIDATA_ENTITY_LABELS.LABEL).from((TableLike)Tables.WIKIDATA_ENTITY_LABELS).where(new Condition[]{Tables.WIKIDATA_ENTITY_LABELS.ENTITY_TYPE.eq((Object)("" + type.code))}).and(WikidataEntityLabels.WIKIDATA_ENTITY_LABELS.ENTITY_ID.eq((Object)id)).and(WikidataEntityLabels.WIKIDATA_ENTITY_LABELS.LANG_ID.eq((Object)l.getId())).fetch();
                    if (result.size() < 1) continue;
                    String string2 = (String)((Record1)result.get(0)).value1();
                    return string2;
                }
                Result result = jooq.select((SelectField)Tables.WIKIDATA_ENTITY_LABELS.LABEL).from((TableLike)Tables.WIKIDATA_ENTITY_LABELS).where(new Condition[]{Tables.WIKIDATA_ENTITY_LABELS.ENTITY_TYPE.eq((Object)("" + type.code))}).and(WikidataEntityLabels.WIKIDATA_ENTITY_LABELS.ENTITY_ID.eq((Object)id)).limit(1).fetch();
                if (result.size() >= 1) {
                    string = (String)((Record1)result.get(0)).value1();
                    return string;
                }
                LOG.warn("no labels for item " + id);
                string = "unknown";
                return string;
            }
            finally {
                this.freeJooq(jooq);
            }
        }
        throw new IllegalArgumentException("Unknown entity type: " + (Object)((Object)type));
    }

    @Override
    public Iterable<WikidataStatement> getByValue(WikidataEntity property, WikidataValue value) throws DaoException {
        WikidataFilter filter = new WikidataFilter.Builder().withPropertyId(property.getId()).withValue(value).build();
        return this.get(filter);
    }

    @Override
    public Iterable<WikidataStatement> getByValue(String propertyName, WikidataValue value) throws DaoException {
        HashSet<Integer> propIds = new HashSet<Integer>();
        for (WikidataEntity e : this.getPropertyByName(propertyName)) {
            propIds.add(e.getId());
        }
        if (propIds.isEmpty()) {
            return new ArrayList<WikidataStatement>();
        }
        WikidataFilter filter = new WikidataFilter.Builder().withPropertyIds(propIds).withValue(value).build();
        return this.get(filter);
    }

    @Override
    public Set<Integer> conceptsWithValue(String propertyName, WikidataValue value) throws DaoException {
        HashSet<Integer> concepts = new HashSet<Integer>();
        for (WikidataStatement st : this.getByValue(propertyName, value)) {
            if (st.getItem().getType() != WikidataEntity.Type.ITEM) continue;
            concepts.add(st.getItem().getId());
        }
        return concepts;
    }

    @Override
    public Set<LocalId> pagesWithValue(String propertyName, WikidataValue value, Language language) throws DaoException {
        HashSet<LocalId> ids = new HashSet<LocalId>();
        for (int conceptId : this.conceptsWithValue(propertyName, value)) {
            UniversalPage up = this.upDao.getById(conceptId);
            if (up == null || !up.isInLanguage(language)) continue;
            ids.add(new LocalId(language, up.getLocalId(language)));
        }
        return ids;
    }

    @Override
    public Iterable<WikidataStatement> get(WikidataFilter filter) throws DaoException {
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        if (filter.getLangIds() != null) {
            throw new UnsupportedOperationException("Filter doesn't support lang ids yet");
        }
        if (filter.getEntityTypes() != null) {
            conditions.add(org.wikibrain.core.jooq.tables.WikidataStatement.WIKIDATA_STATEMENT.ENTITY_TYPE.in(filter.getEntityTypeCodes()));
        }
        if (filter.getEntityIds() != null) {
            conditions.add(org.wikibrain.core.jooq.tables.WikidataStatement.WIKIDATA_STATEMENT.ENTITY_ID.in(filter.getEntityIds()));
        }
        if (filter.getPropertyIds() != null) {
            conditions.add(org.wikibrain.core.jooq.tables.WikidataStatement.WIKIDATA_STATEMENT.PROP_ID.in(filter.getPropertyIds()));
        }
        if (filter.getRanks() != null) {
            conditions.add(org.wikibrain.core.jooq.tables.WikidataStatement.WIKIDATA_STATEMENT.RANK.in(filter.getRankOrdinals()));
        }
        if (filter.getValues() != null) {
            String type = null;
            ArrayList<String> values = new ArrayList<String>();
            for (WikidataValue value : filter.getValues()) {
                values.add(this.encodeValue(value));
                if (type == null) {
                    type = value.getTypeName();
                }
                if (type.equals(value.getTypeName())) continue;
                throw new IllegalArgumentException("All wikidata filter values must have the same type");
            }
            conditions.add(org.wikibrain.core.jooq.tables.WikidataStatement.WIKIDATA_STATEMENT.VAL_TYPE.eq((Object)type.toLowerCase()).and(org.wikibrain.core.jooq.tables.WikidataStatement.WIKIDATA_STATEMENT.VAL_STR.in(values)));
        }
        DSLContext jooq = this.getJooq();
        Cursor result = jooq.select(new SelectField[0]).from((TableLike)Tables.WIKIDATA_STATEMENT).where(conditions).fetchLazy(this.getFetchSize());
        return new SimpleSqlDaoIterable<WikidataStatement>(result, jooq){

            public WikidataStatement transform(Record r) {
                try {
                    return WikidataSqlDao.this.buildStatement(r);
                }
                catch (DaoException e) {
                    AbstractSqlDao.LOG.warn(e.getMessage(), (Throwable)e);
                    return null;
                }
            }
        };
    }

    public Iterable<WikidataStatement> get(DaoFilter daoFilter) throws DaoException {
        throw new UnsupportedOperationException();
    }

    public int getCount(DaoFilter daoFilter) throws DaoException {
        throw new UnsupportedOperationException();
    }

    protected WikidataStatement buildStatement(Record record) throws DaoException {
        WikidataValue val;
        if (record == null) {
            return null;
        }
        WikidataEntity item = new WikidataEntity(WikidataEntity.Type.getByCode(((String)record.getValue((Field)Tables.WIKIDATA_STATEMENT.ENTITY_TYPE)).charAt(0)), (Integer)record.getValue((Field)Tables.WIKIDATA_STATEMENT.ENTITY_ID));
        WikidataEntity prop = this.getProperty((Integer)record.getValue((Field)Tables.WIKIDATA_STATEMENT.PROP_ID));
        Short rankOrdinal = (Short)record.getValue((Field)Tables.WIKIDATA_STATEMENT.RANK);
        JsonElement json = new JsonParser().parse((String)record.getValue((Field)Tables.WIKIDATA_STATEMENT.VAL_STR));
        try {
            val = this.parser.jsonToValue((String)record.getValue((Field)Tables.WIKIDATA_STATEMENT.VAL_TYPE), json);
        }
        catch (WpParseException e) {
            throw new DaoException((Exception)((Object)e));
        }
        WikidataStatement stmt = new WikidataStatement((String)record.getValue((Field)Tables.WIKIDATA_STATEMENT.ID), item, prop, val, WikidataStatement.Rank.values()[rankOrdinal]);
        return stmt;
    }

    public static class Provider
    extends org.wikibrain.conf.Provider<WikidataDao> {
        public Provider(Configurator configurator, Configuration config) throws ConfigurationException {
            super(configurator, config);
        }

        public Class<WikidataDao> getType() {
            return WikidataDao.class;
        }

        public String getPath() {
            return "dao.wikidata";
        }

        public WikidataDao get(String name, Config config, Map<String, String> runtimeParams) throws ConfigurationException {
            if (!config.getString("type").equals("sql")) {
                return null;
            }
            try {
                WikidataSqlDao dao = new WikidataSqlDao((WpDataSource)this.getConfigurator().get(WpDataSource.class, config.getString("dataSource")), (LocalPageDao)this.getConfigurator().get(LocalPageDao.class), (UniversalPageDao)this.getConfigurator().get(UniversalPageDao.class));
                String cachePath = this.getConfig().get().getString("dao.sqlCachePath");
                File cacheDir = new File(cachePath);
                if (!cacheDir.isDirectory()) {
                    cacheDir.mkdirs();
                }
                dao.useCache(cacheDir);
                return dao;
            }
            catch (DaoException e) {
                throw new ConfigurationException((Exception)((Object)e));
            }
        }
    }
}

