/*
 * Decompiled with CFR 0.152.
 */
package org.wikibrain.wikidata;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;

public class WikidataValue
implements Serializable {
    private Type type;
    private String typeName;
    private Object value;
    private JsonElement jsonValue;

    public static WikidataValue forItem(int itemId) {
        JsonObject obj = new JsonObject();
        obj.addProperty("entity-type", "item");
        obj.addProperty("numeric-id", (Number)itemId);
        return new WikidataValue(Type.ITEM, (Object)itemId, (JsonElement)obj);
    }

    public static WikidataValue forProperty(int propId) {
        JsonObject obj = new JsonObject();
        obj.addProperty("entity-type", "property");
        obj.addProperty("numeric-id", (Number)propId);
        return new WikidataValue(Type.PROPERTY, (Object)propId, (JsonElement)obj);
    }

    public static WikidataValue forInt(int value) {
        return new WikidataValue(Type.INT, (Object)value, (JsonElement)new JsonPrimitive((Number)value));
    }

    public static WikidataValue forString(String s) {
        return new WikidataValue(Type.STRING, (Object)s, (JsonElement)new JsonPrimitive(s));
    }

    public WikidataValue(String typeName, Object value, JsonElement jsonValue) {
        for (Type t : Type.values()) {
            if (!t.toString().toLowerCase().equals(typeName.toLowerCase())) continue;
            this.type = t;
            this.typeName = t.toString();
        }
        if (this.type == null) {
            this.type = Type.OTHER;
            this.typeName = typeName;
        }
        this.value = value;
        this.jsonValue = jsonValue;
    }

    public WikidataValue(Type type, Object value, JsonElement jsonValue) {
        this.type = type;
        this.typeName = type.toString();
        this.value = value;
        this.jsonValue = jsonValue;
    }

    private void writeObject(ObjectOutputStream o) throws IOException {
        o.writeObject((Object)this.type);
        o.writeObject(this.typeName);
        o.writeObject(this.value);
        o.writeObject(this.jsonValue.toString());
    }

    private void readObject(ObjectInputStream o) throws IOException, ClassNotFoundException {
        this.type = (Type)((Object)o.readObject());
        this.typeName = (String)o.readObject();
        this.value = o.readObject();
        this.jsonValue = new JsonParser().parse((String)o.readObject());
    }

    public Type getType() {
        return this.type;
    }

    public Object getValue() {
        return this.value;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public Date getTimeValue() {
        return (Date)this.value;
    }

    public String getStringValue() {
        return this.value.toString();
    }

    public int getItemValue() {
        return (Integer)this.value;
    }

    public int getIntValue() {
        if (this.value instanceof Map && ((Map)this.value).containsKey("amount")) {
            return Integer.valueOf((String)((Map)this.value).get("amount"));
        }
        return (Integer)this.value;
    }

    public JsonElement getJsonValue() {
        return this.jsonValue;
    }

    public String toString() {
        return "WikidataValue{typeName='" + this.typeName + '\'' + ", value=" + this.value + '}';
    }

    public static enum Type {
        ITEM,
        PROPERTY,
        TIME,
        STRING,
        INT,
        NOVALUE,
        SOMEVALUE,
        OTHER;

    }
}

