/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal;

import com.bigdata.rdf.internal.InlineURIHandler;
import com.bigdata.rdf.internal.impl.literal.AbstractLiteralIV;
import com.bigdata.rdf.internal.impl.uri.URIExtensionIV;
import com.bigdata.rdf.model.BigdataLiteral;
import com.bigdata.rdf.vocab.Vocabulary;
import java.util.Arrays;
import java.util.List;
import org.openrdf.model.URI;

public class NormalizingInlineUriHandler
extends InlineURIHandler {
    private final InlineURIHandler next;
    private final List<String> normalizedPrefixes;

    public NormalizingInlineUriHandler(InlineURIHandler next, String ... normalizedPrefixes) {
        this(next, Arrays.asList(normalizedPrefixes));
    }

    public NormalizingInlineUriHandler(InlineURIHandler next, List<String> normalizedPrefixes) {
        super(next.getNamespace());
        this.next = next;
        this.normalizedPrefixes = normalizedPrefixes;
    }

    public void init(Vocabulary vocab) {
        super.init(vocab);
        this.next.init(vocab);
    }

    protected URIExtensionIV createInlineIV(URI uri) {
        if (this.namespaceIV == null) {
            return null;
        }
        for (String prefix : this.normalizedPrefixes) {
            if (!uri.stringValue().startsWith(prefix)) continue;
            AbstractLiteralIV localNameIv = this.next.createInlineIV(uri.stringValue().substring(prefix.length()));
            if (localNameIv == null) {
                return null;
            }
            return new URIExtensionIV(localNameIv, this.namespaceIV);
        }
        return this.next.createInlineIV(uri);
    }

    public String getLocalNameFromDelegate(AbstractLiteralIV<BigdataLiteral, ?> delegate) {
        return this.next.getLocalNameFromDelegate(delegate);
    }

    protected AbstractLiteralIV createInlineIV(String localName) {
        return this.next.createInlineIV(localName);
    }
}

