/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.query.rdf.blazegraph.label;

import com.bigdata.bop.BOp;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IConstant;
import com.bigdata.bop.IVariable;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.sparql.ast.AssignmentNode;
import com.bigdata.rdf.sparql.ast.ConstantNode;
import com.bigdata.rdf.sparql.ast.JoinGroupNode;
import com.bigdata.rdf.sparql.ast.ProjectionNode;
import com.bigdata.rdf.sparql.ast.StatementPatternNode;
import com.bigdata.rdf.sparql.ast.StaticAnalysis;
import com.bigdata.rdf.sparql.ast.TermNode;
import com.bigdata.rdf.sparql.ast.VarNode;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpContext;
import com.bigdata.rdf.sparql.ast.optimizers.AbstractJoinGroupOptimizer;
import com.bigdata.rdf.sparql.ast.service.ServiceNode;
import com.bigdata.rdf.store.BD;
import org.apache.log4j.Logger;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.vocabulary.RDFS;
import org.openrdf.model.vocabulary.SKOS;

public class EmptyLabelServiceOptimizer
extends AbstractJoinGroupOptimizer {
    private static final Logger log = Logger.getLogger(EmptyLabelServiceOptimizer.class);
    private static final URI DESCRIPTION = new URIImpl("http://schema.org/description");

    protected void optimizeJoinGroup(AST2BOpContext ctx, StaticAnalysis sa, IBindingSet[] bSets, JoinGroupNode op) {
        for (ServiceNode service : op.getServiceNodes()) {
            BigdataValue serviceRef = service.getServiceRef().getValue();
            if (serviceRef == null || !serviceRef.stringValue().startsWith("http://wikiba.se/ontology#label")) continue;
            JoinGroupNode g = (JoinGroupNode)service.getGraphPattern();
            boolean foundArg = false;
            for (BOp st : g.args()) {
                StatementPatternNode sn = (StatementPatternNode)st;
                if (sn.s().isConstant() && BD.SERVICE_PARAM.equals((Object)sn.s().getValue())) continue;
                foundArg = true;
                break;
            }
            if (foundArg) continue;
            this.addResolutions(ctx, g, sa.getQueryRoot().getProjection());
            return;
        }
    }

    private void addResolutions(AST2BOpContext ctx, JoinGroupNode g, ProjectionNode p) {
        for (AssignmentNode a : p) {
            boolean replaced;
            IVariable var = a.getVar();
            if (a.getValueExpression() != var || !(replaced = this.addResolutionIfSuffix(ctx, g, "AltLabel", SKOS.ALT_LABEL, (IVariable<IV>)var) || this.addResolutionIfSuffix(ctx, g, "Label", RDFS.LABEL, (IVariable<IV>)var) || this.addResolutionIfSuffix(ctx, g, "Description", DESCRIPTION, (IVariable<IV>)var)) || !log.isDebugEnabled()) continue;
            log.debug((Object)("Resolving " + var + " using a label lookup."));
        }
    }

    private boolean addResolutionIfSuffix(AST2BOpContext ctx, JoinGroupNode g, String suffix, URI labelType, IVariable<IV> var) {
        if (!var.getName().endsWith(suffix)) {
            return false;
        }
        String source = var.getName().substring(0, var.getName().length() - suffix.length());
        IConstant labelTypeAsConstant = ctx.getAbstractTripleStore().getVocabulary().getConstant((Value)labelType);
        g.addArg((BOp)new StatementPatternNode((TermNode)new VarNode(source), (TermNode)new ConstantNode(labelTypeAsConstant), (TermNode)new VarNode(var)));
        return true;
    }
}

