/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.query.rdf.blazegraph;

import com.bigdata.bop.BOpContextBase;
import com.bigdata.bop.IValueExpression;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.constraints.DateBOp;
import com.bigdata.rdf.sail.webapp.BigdataRDFServletContextListener;
import com.bigdata.rdf.sparql.ast.FunctionRegistry;
import com.bigdata.rdf.sparql.ast.GlobalAnnotations;
import com.bigdata.rdf.sparql.ast.IValueExpressionNode;
import com.bigdata.rdf.sparql.ast.ValueExpressionNode;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpUtility;
import com.bigdata.rdf.sparql.ast.eval.AbstractServiceFactoryBase;
import com.bigdata.rdf.sparql.ast.service.IServiceOptions;
import com.bigdata.rdf.sparql.ast.service.ServiceCall;
import com.bigdata.rdf.sparql.ast.service.ServiceCallCreateParams;
import com.bigdata.rdf.sparql.ast.service.ServiceFactory;
import com.bigdata.rdf.sparql.ast.service.ServiceRegistry;
import java.util.Map;
import javax.servlet.ServletContextEvent;
import org.openrdf.model.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wikidata.query.rdf.blazegraph.constraints.WikibaseDateBOp;
import org.wikidata.query.rdf.blazegraph.constraints.WikibaseNowBOp;
import org.wikidata.query.rdf.blazegraph.label.LabelService;

public class WikibaseContextListener
extends BigdataRDFServletContextListener {
    private static final Logger log = LoggerFactory.getLogger(WikibaseContextListener.class);

    public static void initializeServices() {
        ServiceRegistry.getInstance().setDefaultServiceFactory((ServiceFactory)new DisableRemotesServiceFactory());
        LabelService.register();
        FunctionRegistry.remove((URI)FunctionRegistry.YEAR);
        FunctionRegistry.add((URI)FunctionRegistry.YEAR, (FunctionRegistry.Factory)WikibaseContextListener.getWikibaseDateBOpFactory(DateBOp.DateOp.YEAR));
        FunctionRegistry.remove((URI)FunctionRegistry.MONTH);
        FunctionRegistry.add((URI)FunctionRegistry.MONTH, (FunctionRegistry.Factory)WikibaseContextListener.getWikibaseDateBOpFactory(DateBOp.DateOp.MONTH));
        FunctionRegistry.remove((URI)FunctionRegistry.DAY);
        FunctionRegistry.add((URI)FunctionRegistry.DAY, (FunctionRegistry.Factory)WikibaseContextListener.getWikibaseDateBOpFactory(DateBOp.DateOp.DAY));
        FunctionRegistry.remove((URI)FunctionRegistry.HOURS);
        FunctionRegistry.add((URI)FunctionRegistry.HOURS, (FunctionRegistry.Factory)WikibaseContextListener.getWikibaseDateBOpFactory(DateBOp.DateOp.HOURS));
        FunctionRegistry.remove((URI)FunctionRegistry.MINUTES);
        FunctionRegistry.add((URI)FunctionRegistry.MINUTES, (FunctionRegistry.Factory)WikibaseContextListener.getWikibaseDateBOpFactory(DateBOp.DateOp.MINUTES));
        FunctionRegistry.remove((URI)FunctionRegistry.SECONDS);
        FunctionRegistry.add((URI)FunctionRegistry.SECONDS, (FunctionRegistry.Factory)WikibaseContextListener.getWikibaseDateBOpFactory(DateBOp.DateOp.SECONDS));
        FunctionRegistry.remove((URI)FunctionRegistry.NOW);
        FunctionRegistry.add((URI)FunctionRegistry.NOW, (FunctionRegistry.Factory)new FunctionRegistry.Factory(){

            public IValueExpression<? extends IV> create(BOpContextBase context, GlobalAnnotations globals, Map<String, Object> scalarValues, ValueExpressionNode ... args) {
                if (args != null && args.length > 0) {
                    throw new IllegalArgumentException("no args for NOW()");
                }
                return new WikibaseNowBOp(globals);
            }
        });
        log.warn("Wikibase services initialized.");
    }

    public void contextInitialized(ServletContextEvent e) {
        super.contextInitialized(e);
        WikibaseContextListener.initializeServices();
    }

    private static FunctionRegistry.Factory getWikibaseDateBOpFactory(final DateBOp.DateOp dateop) {
        return new FunctionRegistry.Factory(){

            public IValueExpression<? extends IV> create(BOpContextBase context, GlobalAnnotations globals, Map<String, Object> scalarValues, ValueExpressionNode ... args) {
                FunctionRegistry.checkArgs((ValueExpressionNode[])args, (Class[])new Class[]{ValueExpressionNode.class});
                IValueExpression left = AST2BOpUtility.toVE((BOpContextBase)context, (GlobalAnnotations)globals, (IValueExpressionNode)args[0]);
                return new WikibaseDateBOp((IValueExpression<? extends IV>)left, dateop, globals);
            }
        };
    }

    private static final class DisableRemotesServiceFactory
    extends AbstractServiceFactoryBase {
        private DisableRemotesServiceFactory() {
        }

        public IServiceOptions getServiceOptions() {
            return null;
        }

        public ServiceCall<?> create(ServiceCallCreateParams params) {
            throw new IllegalArgumentException("Service call not allowed: " + params.getServiceURI());
        }
    }
}

