/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.query.rdf.blazegraph.constraints;

import com.bigdata.bop.BOp;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.NV;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.constraints.INeedsMaterialization;
import com.bigdata.rdf.internal.constraints.IVValueExpression;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.sparql.ast.GlobalAnnotations;
import java.util.Calendar;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.openrdf.model.vocabulary.XMLSchema;
import org.wikidata.query.rdf.common.WikibaseDate;

public class WikibaseNowBOp
extends IVValueExpression<IV>
implements INeedsMaterialization {
    private static final long serialVersionUID = 9136864442064392445L;

    public WikibaseNowBOp(GlobalAnnotations globals) {
        this(BOp.NOARGS, WikibaseNowBOp.anns((GlobalAnnotations)globals, (NV[])new NV[0]));
    }

    public WikibaseNowBOp(BOp[] args, Map<String, Object> anns) {
        super(args, anns);
    }

    public WikibaseNowBOp(WikibaseNowBOp op) {
        super((IVValueExpression)op);
    }

    public IV get(IBindingSet bs) {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"), Locale.ROOT);
        WikibaseDate wd = WikibaseDate.fromSecondsSinceEpoch((long)(cal.getTimeInMillis() / 1000L));
        return super.asIV((BigdataValue)this.getValueFactory().createLiteral(wd.toString(WikibaseDate.ToStringFormat.DATE_TIME), XMLSchema.DATETIME), bs);
    }

    public String toString() {
        return "now()";
    }

    public INeedsMaterialization.Requirement getRequirement() {
        return INeedsMaterialization.Requirement.NEVER;
    }
}

