/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.query.rdf.blazegraph.geo;

import com.bigdata.bop.BOp;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.sparql.ast.ConstantNode;
import com.bigdata.rdf.sparql.ast.DummyConstantNode;
import com.bigdata.rdf.sparql.ast.JoinGroupNode;
import com.bigdata.rdf.sparql.ast.StatementPatternNode;
import com.bigdata.rdf.sparql.ast.TermNode;
import com.bigdata.rdf.sparql.ast.eval.ServiceParams;
import com.bigdata.rdf.sparql.ast.service.ServiceCallCreateParams;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.vocab.Vocabulary;
import com.bigdata.service.geospatial.GeoSpatial;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.URIImpl;
import org.wikidata.query.rdf.blazegraph.geo.GeoService;

public class GeoBoxService
extends GeoService {
    public static final URI SERVICE_KEY = new URIImpl("http://wikiba.se/ontology#box");
    public static final URIImpl NE_PARAM = new URIImpl("http://wikiba.se/ontology#cornerNorthEast");
    public static final URIImpl SW_PARAM = new URIImpl("http://wikiba.se/ontology#cornerSouthWest");

    @Override
    protected JoinGroupNode buildServiceNode(ServiceCallCreateParams params, ServiceParams serviceParams) {
        AbstractTripleStore store = params.getTripleStore();
        Vocabulary voc = store.getVocabulary();
        BigdataValueFactory vf = store.getValueFactory();
        StatementPatternNode pattern = this.getPatternNode(params);
        TermNode searchVar = pattern.s();
        TermNode predicate = pattern.p();
        TermNode locationVar = pattern.o();
        JoinGroupNode newGroup = new JoinGroupNode();
        newGroup.addArg((BOp)new StatementPatternNode(searchVar, (TermNode)new DummyConstantNode((BigdataValue)vf.asValue(GeoSpatial.SEARCH)), (TermNode)new DummyConstantNode((BigdataValue)vf.createLiteral(GeoSpatial.GeoFunction.IN_RECTANGLE.toString()))));
        newGroup.addArg((BOp)new StatementPatternNode(searchVar, (TermNode)new DummyConstantNode((BigdataValue)vf.asValue(GeoSpatial.PREDICATE)), predicate));
        newGroup.addArg((BOp)new StatementPatternNode(searchVar, (TermNode)new DummyConstantNode((BigdataValue)vf.asValue(GeoSpatial.SEARCH_DATATYPE)), (TermNode)new ConstantNode(voc.getConstant((Value)new URIImpl("http://www.opengis.net/ont/geosparql#wktLiteral")))));
        newGroup.addArg((BOp)new StatementPatternNode(searchVar, (TermNode)new DummyConstantNode((BigdataValue)vf.asValue(GeoSpatial.SPATIAL_RECTANGLE_NORTH_EAST)), this.getParam(serviceParams, (URI)NE_PARAM)));
        newGroup.addArg((BOp)new StatementPatternNode(searchVar, (TermNode)new DummyConstantNode((BigdataValue)vf.asValue(GeoSpatial.SPATIAL_RECTANGLE_SOUTH_WEST)), this.getParam(serviceParams, (URI)SW_PARAM)));
        newGroup.addArg((BOp)new StatementPatternNode(searchVar, (TermNode)new DummyConstantNode((BigdataValue)vf.asValue(GeoSpatial.LOCATION_VALUE)), locationVar));
        newGroup.addArg((BOp)new StatementPatternNode(searchVar, (TermNode)new DummyConstantNode((BigdataValue)vf.asValue(GeoSpatial.COORD_SYSTEM)), this.getGlobeNode(vf, serviceParams)));
        return newGroup;
    }
}

