/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.query.rdf.blazegraph.inline.literal;

import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.gis.ICoordinate;
import com.bigdata.rdf.internal.impl.literal.XSDNumericIV;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.sparql.ast.DummyConstantNode;
import com.bigdata.service.geospatial.GeoSpatialSearchException;
import com.bigdata.service.geospatial.IGeoSpatialLiteralSerializer;
import org.openrdf.model.URI;
import org.openrdf.model.impl.URIImpl;
import org.wikidata.query.rdf.common.WikibasePoint;
import org.wikidata.query.rdf.common.uri.WikibaseUris;

public class WKTSerializer
implements IGeoSpatialLiteralSerializer {
    private static final long serialVersionUID = -8893919944620967416L;
    private final String urlPrefix = WikibaseUris.getURISystem().entity() + "Q";
    public static final String NO_GLOBE = System.getProperty(WKTSerializer.class.getName() + ".noGlobe", "0");
    private static final URI WKT_LITERAL_URI = new URIImpl("http://www.opengis.net/ont/geosparql#wktLiteral");

    public String fromComponents(Object[] components) {
        if (components == null) {
            return "";
        }
        if (components.length != 3) {
            throw new GeoSpatialSearchException("Expected component string of lenth 2, but was " + components.length);
        }
        String[] strComponents = new String[]{components[0].toString(), components[1].toString(), components[2].toString()};
        WikibasePoint point = strComponents[2].equals(NO_GLOBE) ? new WikibasePoint(strComponents, null, WikibasePoint.CoordinateOrder.LONG_LAT) : new WikibasePoint(strComponents, this.urlPrefix + strComponents[2], WikibasePoint.CoordinateOrder.LONG_LAT);
        return point.toString();
    }

    public String trimCoordURI(String uri) {
        if (!uri.startsWith(this.urlPrefix)) {
            throw new GeoSpatialSearchException("Invalid coordinate URI for the WKT value");
        }
        return uri.substring(this.urlPrefix.length());
    }

    public String[] toComponents(String literalString) {
        if (literalString == null) {
            return new String[0];
        }
        String[] comps = new String[3];
        WikibasePoint point = new WikibasePoint(literalString);
        comps[0] = point.getLongitude();
        comps[1] = point.getLatitude();
        String globe = point.getGlobe();
        comps[2] = globe != null ? this.trimCoordURI(globe) : NO_GLOBE;
        return comps;
    }

    public IV<?, ?> serializeCoordSystem(BigdataValueFactory vf, Object coordinateSystem) {
        return DummyConstantNode.toDummyIV((BigdataValue)vf.createURI(this.urlPrefix + coordinateSystem.toString()));
    }

    public IV<?, ?> serializeCustomFields(BigdataValueFactory vf, Object ... arg1) {
        throw new IllegalArgumentException("Custom fields are not supported for this format");
    }

    public IV<?, ?> serializeLatitude(BigdataValueFactory vf, Object latitude) {
        return new XSDNumericIV(((Double)latitude).doubleValue());
    }

    public IV<?, ?> serializeLocation(BigdataValueFactory vf, Object lat, Object lon) {
        WikibasePoint p = new WikibasePoint(new String[]{lat.toString(), lon.toString()}, null, WikibasePoint.CoordinateOrder.LAT_LONG);
        return DummyConstantNode.toDummyIV((BigdataValue)vf.createLiteral(p.toString(), WKT_LITERAL_URI));
    }

    public IV<?, ?> serializeLocationAndTime(BigdataValueFactory arg0, Object arg1, Object arg2, Object arg3) {
        throw new IllegalArgumentException("Time fields are not supported for this format");
    }

    public IV<?, ?> serializeLongitude(BigdataValueFactory vf, Object longitude) {
        return new XSDNumericIV(((Double)longitude).doubleValue());
    }

    public IV<?, ?> serializeTime(BigdataValueFactory arg0, Object arg1) {
        throw new IllegalArgumentException("Time fields are not supported for this format");
    }

    public IV<?, ?> serializeDistance(BigdataValueFactory vf, Double distance, ICoordinate.UNITS unit) {
        return new XSDNumericIV((double)Math.round(distance * 1000.0) / 1000.0);
    }
}

