/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.query.rdf.blazegraph.inline.uri;

import com.bigdata.rdf.internal.InlineURIHandler;
import com.bigdata.rdf.internal.impl.literal.AbstractLiteralIV;
import com.bigdata.rdf.internal.impl.literal.UUIDLiteralIV;
import com.bigdata.rdf.internal.impl.literal.XSDIntegerIV;
import com.bigdata.rdf.model.BigdataLiteral;
import java.math.BigInteger;
import java.util.Locale;
import java.util.UUID;
import org.apache.log4j.Logger;

public class WikibaseStyleStatementInlineUriHandler
extends InlineURIHandler {
    private static final Logger log = Logger.getLogger(WikibaseStyleStatementInlineUriHandler.class);

    public WikibaseStyleStatementInlineUriHandler(String namespace) {
        super(namespace);
    }

    protected AbstractLiteralIV createInlineIV(String localName) {
        switch (localName.charAt(0)) {
            case 'Q': 
            case 'q': {
                return WikibaseStyleStatementInlineUriHandler.inlineIvFrom(1, localName);
            }
            case 'P': 
            case 'p': {
                return WikibaseStyleStatementInlineUriHandler.inlineIvFrom(-1, localName);
            }
        }
        try {
            return new UUIDLiteralIV(UUID.fromString(localName));
        }
        catch (IllegalArgumentException e) {
            log.debug((Object)("Invalid uuid:  " + localName), (Throwable)e);
            return null;
        }
    }

    public String getLocalNameFromDelegate(AbstractLiteralIV<BigdataLiteral, ?> delegate) {
        switch (delegate.getDTE()) {
            case UUID: {
                return delegate.stringValue().toUpperCase(Locale.ROOT);
            }
            case XSDInteger: {
                BigInteger i = delegate.integerValue();
                long least = i.longValue();
                i = i.shiftRight(64);
                long most = i.longValue();
                i = i.shiftRight(64);
                long entity = i.longValue();
                StringBuilder b = new StringBuilder();
                if (entity < 0L) {
                    entity = -entity;
                    b.append('P');
                } else {
                    b.append('Q');
                }
                b.append(entity).append('-').append(new UUID(most, least).toString().toUpperCase(Locale.ROOT));
                return b.toString();
            }
        }
        return super.getLocalNameFromDelegate(delegate);
    }

    private static AbstractLiteralIV inlineIvFrom(int signum, String localName) {
        int firstDash = localName.indexOf(45);
        long entity = Long.valueOf(localName.substring(1, firstDash), 10);
        try {
            UUID u = UUID.fromString(localName.substring(firstDash + 1));
            BigInteger i = BigInteger.valueOf((long)signum * entity);
            i = i.shiftLeft(64).or(WikibaseStyleStatementInlineUriHandler.unsigned(u.getMostSignificantBits()));
            i = i.shiftLeft(64).or(WikibaseStyleStatementInlineUriHandler.unsigned(u.getLeastSignificantBits()));
            return new XSDIntegerIV(i);
        }
        catch (IllegalArgumentException e) {
            Logger.getLogger(WikibaseStyleStatementInlineUriHandler.class).warn((Object)"tmp", (Throwable)e);
            return null;
        }
    }

    private static BigInteger unsigned(long l) {
        BigInteger i = BigInteger.valueOf(l & Long.MAX_VALUE);
        if (l < 0L) {
            i = i.setBit(63);
        }
        return i;
    }
}

