/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.query.rdf.blazegraph.constraints;

import com.bigdata.bop.BOp;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IValueExpression;
import com.bigdata.bop.NV;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.constraints.INeedsMaterialization;
import com.bigdata.rdf.internal.constraints.IVValueExpression;
import com.bigdata.rdf.internal.gis.CoordinateDD;
import com.bigdata.rdf.model.BigdataLiteral;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.sparql.ast.GlobalAnnotations;
import java.util.Map;
import org.openrdf.model.URI;
import org.openrdf.model.impl.URIImpl;
import org.wikidata.query.rdf.blazegraph.geo.GeoUtils;
import org.wikidata.query.rdf.common.WikibasePoint;

public class WikibaseCornerBOp
extends IVValueExpression<IV>
implements INeedsMaterialization {
    private static final long serialVersionUID = -811348263515935773L;

    public WikibaseCornerBOp(BOp[] args, Map<String, Object> anns) {
        super(args, anns);
        if (args.length < 2 || args[0] == null || args[1] == null) {
            throw new IllegalArgumentException();
        }
    }

    public WikibaseCornerBOp(IValueExpression<? extends IV> left, IValueExpression<? extends IV> right, Corners corner, GlobalAnnotations globals) {
        this(new BOp[]{left, right}, WikibaseCornerBOp.anns((GlobalAnnotations)globals, (NV[])new NV[]{new NV(Annotations.OP, (Object)corner)}));
    }

    public WikibaseCornerBOp(WikibaseCornerBOp op) {
        super((IVValueExpression)op);
    }

    private Corners corner() {
        return (Corners)((Object)this.getRequiredProperty(Annotations.OP));
    }

    protected CoordinateDD getCoordinateFromWP(WikibasePoint point) {
        return new CoordinateDD(Double.parseDouble(point.getLatitude()), Double.parseDouble(point.getLongitude()));
    }

    public IV get(IBindingSet bindingSet) {
        WikibasePoint wp;
        IV east = this.getAndCheckLiteral(0, bindingSet);
        IV west = this.getAndCheckLiteral(1, bindingSet);
        GeoUtils.Box box = new GeoUtils.Box(GeoUtils.pointFromIV(east), GeoUtils.pointFromIV(west));
        if (this.corner() == Corners.NE) {
            if (!box.switched()) {
                return east;
            }
            wp = box.northEast();
        } else {
            if (!box.switched()) {
                return west;
            }
            wp = box.southWest();
        }
        BigdataLiteral newpoint = this.getValueFactory().createLiteral(wp.toString(), (URI)new URIImpl("http://www.opengis.net/ont/geosparql#wktLiteral"));
        return super.asIV((BigdataValue)newpoint, bindingSet);
    }

    public INeedsMaterialization.Requirement getRequirement() {
        return INeedsMaterialization.Requirement.ALWAYS;
    }

    public static interface Annotations
    extends BOp.Annotations {
        public static final String OP = (WikibaseCornerBOp.class.getName() + ".op").intern();
    }

    public static enum Corners {
        NE,
        SW;

    }
}

