/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.query.rdf.blazegraph.geo;

import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.constraints.IVValueExpression;
import com.bigdata.rdf.internal.gis.CoordinateDD;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.model.impl.URIImpl;
import org.wikidata.query.rdf.common.WikibasePoint;

public final class GeoUtils {
    public static final URI WKT_LITERAL_URI = new URIImpl("http://www.opengis.net/ont/geosparql#wktLiteral");

    private GeoUtils() {
    }

    public static Literal pointLiteral(String point) {
        return new LiteralImpl(point, WKT_LITERAL_URI);
    }

    public static WikibasePoint pointFromIV(IV iv) {
        return new WikibasePoint(IVValueExpression.asLiteral((IV)iv).stringValue());
    }

    public static CoordinateDD getCoordinate(WikibasePoint point) {
        return new CoordinateDD(Double.parseDouble(point.getLatitude()), Double.parseDouble(point.getLongitude()));
    }

    public static CoordinateDD getCoordinate(IV iv) {
        return GeoUtils.getCoordinate(GeoUtils.pointFromIV(iv));
    }

    public static class Box {
        private final WikibasePoint ne;
        private final WikibasePoint sw;
        private boolean switched;

        public Box(WikibasePoint east, WikibasePoint west) {
            CoordinateDD eastPoint = GeoUtils.getCoordinate(east);
            CoordinateDD westPoint = GeoUtils.getCoordinate(west);
            if (eastPoint.northSouth >= westPoint.northSouth) {
                this.ne = east;
                this.sw = west;
            } else {
                this.ne = new WikibasePoint(new String[]{east.getLongitude(), west.getLatitude()}, WikibasePoint.CoordinateOrder.LONG_LAT);
                this.sw = new WikibasePoint(new String[]{west.getLongitude(), east.getLatitude()}, WikibasePoint.CoordinateOrder.LONG_LAT);
                this.switched = true;
            }
        }

        public WikibasePoint northEast() {
            return this.ne;
        }

        public WikibasePoint southWest() {
            return this.sw;
        }

        public boolean switched() {
            return this.switched;
        }
    }
}

