/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.query.rdf.blazegraph.inline.uri;

import com.bigdata.rdf.internal.InlineSignedIntegerURIHandler;
import com.bigdata.rdf.internal.InlineURIHandler;
import com.bigdata.rdf.internal.impl.literal.AbstractLiteralIV;
import com.bigdata.rdf.model.BigdataLiteral;
import java.math.BigInteger;

public class ValuePropertiesInlineUriHandler
extends InlineURIHandler {
    private static final String SUFFIX = "-value";

    public ValuePropertiesInlineUriHandler(String namespace) {
        super(namespace);
    }

    protected AbstractLiteralIV createInlineIV(String localName) {
        BigInteger value;
        try {
            if (localName.endsWith(SUFFIX)) {
                localName = localName.substring(0, localName.length() - SUFFIX.length());
                value = new BigInteger(localName, 10).negate();
            } else {
                value = new BigInteger(localName, 10);
            }
        }
        catch (NumberFormatException e) {
            return null;
        }
        return InlineSignedIntegerURIHandler.createInlineIV((BigInteger)value);
    }

    public String getLocalNameFromDelegate(AbstractLiteralIV<BigdataLiteral, ?> delegate) {
        BigInteger value = delegate.integerValue();
        if (value.compareTo(BigInteger.ZERO) < 0) {
            return value.negate().toString() + SUFFIX;
        }
        return value.toString();
    }
}

