/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.query.rdf.blazegraph.label;

import com.bigdata.bop.BOp;
import com.bigdata.bop.IBindingSet;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.sparql.ast.JoinGroupNode;
import com.bigdata.rdf.sparql.ast.QueryRoot;
import com.bigdata.rdf.sparql.ast.QueryType;
import com.bigdata.rdf.sparql.ast.StatementPatternNode;
import com.bigdata.rdf.sparql.ast.StaticAnalysis;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpContext;
import com.bigdata.rdf.sparql.ast.optimizers.AbstractJoinGroupOptimizer;
import com.bigdata.rdf.sparql.ast.service.ServiceNode;
import com.bigdata.rdf.store.BD;
import java.util.ArrayList;

public class LabelServiceExtractOptimizer
extends AbstractJoinGroupOptimizer {
    public static final String EXTRACTOR_ANNOTATION = LabelServiceExtractOptimizer.class.getName() + ".extractedStatements";

    protected void optimizeJoinGroup(AST2BOpContext ctx, StaticAnalysis sa, IBindingSet[] bSets, JoinGroupNode op) {
        QueryRoot root = sa.getQueryRoot();
        if (root.getQueryType() == QueryType.ASK) {
            return;
        }
        for (ServiceNode service : op.getServiceNodes()) {
            BigdataValue serviceRef = service.getServiceRef().getValue();
            if (serviceRef == null || !serviceRef.stringValue().startsWith("http://wikiba.se/ontology#label")) continue;
            JoinGroupNode g = (JoinGroupNode)service.getGraphPattern();
            ArrayList<BOp> extractedNodes = new ArrayList<BOp>();
            for (BOp st : g.args()) {
                StatementPatternNode sn = (StatementPatternNode)st;
                if (sn.s().isConstant() && BD.SERVICE_PARAM.equals((Object)sn.s().getValue())) continue;
                extractedNodes.add(st);
            }
            for (BOp node : extractedNodes) {
                g.removeArg(node);
            }
            if (extractedNodes.isEmpty()) continue;
            service.annotations().put(EXTRACTOR_ANNOTATION, extractedNodes);
        }
    }
}

