/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.query.rdf.blazegraph.geo;

import com.bigdata.bop.IVariable;
import com.bigdata.bop.IVariableOrConstant;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.sparql.ast.DummyConstantNode;
import com.bigdata.rdf.sparql.ast.GraphPatternGroup;
import com.bigdata.rdf.sparql.ast.IGroupMemberNode;
import com.bigdata.rdf.sparql.ast.JoinGroupNode;
import com.bigdata.rdf.sparql.ast.StatementPatternNode;
import com.bigdata.rdf.sparql.ast.TermNode;
import com.bigdata.rdf.sparql.ast.eval.AbstractServiceFactory;
import com.bigdata.rdf.sparql.ast.eval.GeoSpatialServiceFactory;
import com.bigdata.rdf.sparql.ast.eval.ServiceParams;
import com.bigdata.rdf.sparql.ast.service.BigdataServiceCall;
import com.bigdata.rdf.sparql.ast.service.IServiceOptions;
import com.bigdata.rdf.sparql.ast.service.ServiceCallCreateParams;
import com.bigdata.rdf.sparql.ast.service.ServiceFactory;
import com.bigdata.rdf.sparql.ast.service.ServiceNode;
import com.bigdata.rdf.sparql.ast.service.ServiceRegistry;
import com.bigdata.rdf.store.BD;
import com.bigdata.service.geospatial.GeoSpatial;
import com.bigdata.service.geospatial.GeoSpatialSearchException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jetty.client.HttpClient;
import org.openrdf.model.URI;
import org.openrdf.model.impl.URIImpl;
import org.wikidata.query.rdf.blazegraph.geo.GeoAroundService;
import org.wikidata.query.rdf.blazegraph.geo.GeoBoxService;
import org.wikidata.query.rdf.blazegraph.inline.literal.WKTSerializer;

public abstract class GeoService
extends AbstractServiceFactory {
    private final GeoSpatialServiceFactory blazegraphService = new GeoSpatialServiceFactory();
    public static final URIImpl GLOBE_PARAM = new URIImpl("http://wikiba.se/ontology#globe");

    public static void register() {
        ServiceRegistry reg = ServiceRegistry.getInstance();
        reg.add(GeoAroundService.SERVICE_KEY, (ServiceFactory)new GeoAroundService());
        reg.addWhitelistURL(GeoAroundService.SERVICE_KEY.toString());
        reg.add(GeoBoxService.SERVICE_KEY, (ServiceFactory)new GeoBoxService());
        reg.addWhitelistURL(GeoBoxService.SERVICE_KEY.toString());
        reg.addWhitelistURL(GeoSpatial.SEARCH.toString());
    }

    public IServiceOptions getServiceOptions() {
        return this.blazegraphService.getServiceOptions();
    }

    protected TermNode getParam(ServiceParams serviceParams, URI paramName) {
        TermNode node = serviceParams.get(paramName, null);
        if (node == null) {
            throw new IllegalArgumentException("Parameter " + paramName + " is required.");
        }
        return node;
    }

    protected abstract JoinGroupNode buildServiceNode(ServiceCallCreateParams var1, ServiceParams var2);

    protected TermNode getGlobeNode(BigdataValueFactory vf, ServiceParams serviceParams) {
        TermNode globeNode = serviceParams.get((URI)GLOBE_PARAM, null);
        if (globeNode == null) {
            return new DummyConstantNode((BigdataValue)vf.createLiteral(WKTSerializer.NO_GLOBE));
        }
        if (!globeNode.isConstant()) {
            throw new IllegalArgumentException("Non-constant globe value is not supported yet.");
        }
        BigdataValue v = globeNode.getValue();
        if (v instanceof BigdataURI) {
            WKTSerializer ser = new WKTSerializer();
            try {
                return new DummyConstantNode((BigdataValue)vf.createLiteral(ser.trimCoordURI(v.stringValue())));
            }
            catch (GeoSpatialSearchException e) {
                return globeNode;
            }
        }
        return globeNode;
    }

    protected StatementPatternNode getPatternNode(ServiceCallCreateParams params) {
        ServiceNode serviceNode = params.getServiceNode();
        if (serviceNode == null) {
            throw new IllegalArgumentException();
        }
        List<StatementPatternNode> patterns = this.getStatementPatterns(serviceNode);
        if (patterns.size() == 0) {
            throw new IllegalArgumentException("This service requires arguments");
        }
        StatementPatternNode pattern = patterns.get(0);
        if (pattern == null) {
            throw new IllegalArgumentException();
        }
        if (!pattern.s().isVariable()) {
            throw new IllegalArgumentException("Search pattern subject must be a variable");
        }
        if (!pattern.p().isConstant()) {
            throw new IllegalArgumentException("Search pattern predicate must be a constant");
        }
        if (!pattern.o().isVariable()) {
            throw new IllegalArgumentException("Search pattern object must be a variable");
        }
        return pattern;
    }

    public BigdataServiceCall create(ServiceCallCreateParams params, ServiceParams serviceParams) {
        if (params == null) {
            throw new IllegalArgumentException();
        }
        JoinGroupNode newGroup = this.buildServiceNode(params, serviceParams);
        BigdataValueFactory vf = params.getTripleStore().getValueFactory();
        ServiceNode newServiceNode = new ServiceNode((TermNode)new DummyConstantNode((BigdataValue)vf.asValue(GeoSpatial.SEARCH)), (GraphPatternGroup)newGroup);
        newServiceNode.setQueryHints(params.getServiceNode().getQueryHints());
        HttpClient client = params.getClientConnectionManager();
        return (BigdataServiceCall)ServiceRegistry.getInstance().toServiceCall(params.getTripleStore(), client, GeoSpatial.SEARCH, newServiceNode, params.getStats());
    }

    protected List<StatementPatternNode> getStatementPatterns(ServiceNode serviceNode) {
        ArrayList<StatementPatternNode> statementPatterns = new ArrayList<StatementPatternNode>();
        for (IGroupMemberNode child : serviceNode.getGraphPattern()) {
            if (child instanceof StatementPatternNode) {
                statementPatterns.add((StatementPatternNode)child);
                continue;
            }
            throw new GeoSpatialSearchException("Nested groups are not allowed.");
        }
        return statementPatterns;
    }

    @SuppressFBWarnings(value={"EC_UNRELATED_CLASS_AND_INTERFACE"}, justification="equals() is actually correct for some subtypes of BigdataValue")
    public Set<IVariable<?>> getRequiredBound(ServiceNode serviceNode) {
        HashSet requiredBound = new HashSet();
        for (StatementPatternNode sp : this.getStatementPatterns(serviceNode)) {
            TermNode subj = sp.s();
            IVariableOrConstant object = sp.o().getValueExpression();
            if (!subj.isConstant() || !BD.SERVICE_PARAM.equals((Object)subj.getValue()) || !(object instanceof IVariable)) continue;
            requiredBound.add((IVariable)object);
        }
        return requiredBound;
    }
}

